/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaContinuousInputPartition;
import org.apache.spark.sql.kafka010.KafkaContinuousReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourcePartitionOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\u000e\u001c\u0001\u0019B\u0011b\u0010\u0001\u0003\u0006\u0004%\ta\u0007!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0005C\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A\u0001\r\u0001B\u0001B\u0003%Q\n\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!)\u0007A!A!\u0002\u00131\u0007\"\u00026\u0001\t\u0003Y\u0007\u0002C:\u0001\u0005\u0004%\ta\u0007;\t\ra\u0004\u0001\u0015!\u0003v\u0011\u001dI\bA1A\u0005\niDaa\u001f\u0001!\u0002\u00131\u0007B\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u001e{\"a\u00111\u0003\u0001A\u0002\u0003\u0007I\u0011A\u000f\u0002\u0016!Q\u0011\u0011\u0005\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAA\u0001\u0011%\u00111\u0011\u0002\u0016\u0017\u000647.Y\"p]RLg.^8vgN#(/Z1n\u0015\taR$\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0011\u0001qeL\u001d\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u00027b]\u001eT\u0011\u0001L\u0001\u0005U\u00064\u0018-\u0003\u0002/S\t1qJ\u00196fGR\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0013M$(/Z1nS:<'B\u0001\u001b6\u0003\u0011\u0011X-\u00193\u000b\u0005Yj\u0012!C2p]:,7\r^8s\u0013\tA\u0014G\u0001\tD_:$\u0018N\\;pkN\u001cFO]3b[B\u0011!(P\u0007\u0002w)\u0011AhH\u0001\tS:$XM\u001d8bY&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u00031ygMZ:fiJ+\u0017\rZ3s+\u0005\t\u0005C\u0001\"D\u001b\u0005Y\u0012B\u0001#\u001c\u0005EY\u0015MZ6b\u001f\u001a47/\u001a;SK\u0006$WM]\u0001\u000e_\u001a47/\u001a;SK\u0006$WM\u001d\u0011\u0002\u0017-\fgm[1QCJ\fWn\u001d\t\u0005\u0011.ku%D\u0001J\u0015\tQ5&\u0001\u0003vi&d\u0017B\u0001'J\u0005\ri\u0015\r\u001d\t\u0003\u001d^s!aT+\u0011\u0005A\u001bV\"A)\u000b\u0005I+\u0013A\u0002\u001fs_>$hHC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16+\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,T\u0003\u001dy\u0007\u000f^5p]N\u0004\"\u0001\u00180\u000e\u0003uS!AS\u000f\n\u0005}k&\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQ\u0006q\u0011N\\5uS\u0006dwJ\u001a4tKR\u001c\bC\u0001\"d\u0013\t!7DA\u000bLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK2KW.\u001b;\u0002\u001d\u0019\f\u0017\u000e\\(o\t\u0006$\u0018\rT8tgB\u0011q\r[\u0007\u0002'&\u0011\u0011n\u0015\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q9A.\u001c8paF\u0014\bC\u0001\"\u0001\u0011\u0015y\u0004\u00021\u0001B\u0011\u00151\u0005\u00021\u0001H\u0011\u0015Q\u0006\u00021\u0001\\\u0011\u0015\u0001\u0007\u00021\u0001N\u0011\u0015\t\u0007\u00021\u0001c\u0011\u0015)\u0007\u00021\u0001g\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgV\tQ\u000f\u0005\u0002hm&\u0011qo\u0015\u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002\u001d%t7\r\\;eK\"+\u0017\rZ3sgV\ta-A\bj]\u000edW\u000fZ3IK\u0006$WM]:!\u0003=Ygn\\<o!\u0006\u0014H/\u001b;j_:\u001cX#\u0001@\u0011\t9{\u00181A\u0005\u0004\u0003\u0003I&aA*fiB!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB2p[6|gNC\u0002\u0002\u000e\u0005\nQa[1gW\u0006LA!!\u0005\u0002\b\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017aE6o_^t\u0007+\u0019:uSRLwN\\:`I\u0015\fH\u0003BA\f\u0003;\u00012aZA\r\u0013\r\tYb\u0015\u0002\u0005+:LG\u000f\u0003\u0005\u0002 9\t\t\u00111\u0001\u007f\u0003\rAH%M\u0001\u0011W:|wO\u001c)beRLG/[8og\u0002B3aDA\u0013!\r9\u0017qE\u0005\u0004\u0003S\u0019&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001b%t\u0017\u000e^5bY>3gm]3u)\t\ty\u0003E\u00021\u0003cI1!a\r2\u0005\u0019yeMZ:fi\u0006\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\t\u0005=\u0012\u0011\b\u0005\u0007\u0003w\t\u0002\u0019A'\u0002\t)\u001cxN\\\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003\u0003\ny\u0005E\u0003h\u0003\u0007\n9%C\u0002\u0002FM\u0013Q!\u0011:sCf\u0004B!!\u0013\u0002L5\t1'C\u0002\u0002NM\u0012a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002RI\u0001\r!a\f\u0002\u000bM$\u0018M\u001d;\u0002;\r\u0014X-\u0019;f\u0007>tG/\u001b8v_V\u001c(+Z1eKJ4\u0015m\u0019;pef$\"!a\u0016\u0011\u0007A\nI&C\u0002\u0002\\E\u0012\u0001eQ8oi&tWo\\;t!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe\u001a\u000b7\r^8ss\u0006!1\u000f^8q)\t\t9\"\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005\u0003/\t)\u0007C\u0004\u0002hU\u0001\r!a\f\u0002\u0007\u0015tG-\u0001\u0007nKJ<Wm\u00144gg\u0016$8\u000f\u0006\u0003\u00020\u00055\u0004bBA8-\u0001\u0007\u0011\u0011O\u0001\b_\u001a47/\u001a;t!\u00159\u00171IA:!\r\u0001\u0014QO\u0005\u0004\u0003o\n$a\u0004)beRLG/[8o\u001f\u001a47/\u001a;\u0002)9,W\rZ:SK\u000e|gNZ5hkJ\fG/[8o)\u00051\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u00035\u000baB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\u0006\u0003\u0002\u0018\u0005\u0015\u0005BBAD3\u0001\u0007Q*A\u0004nKN\u001c\u0018mZ3")
public class KafkaContinuousStream
implements ContinuousStream,
Logging {
    private final KafkaOffsetReader offsetReader;
    private final Map<String, Object> kafkaParams;
    private final KafkaOffsetRangeLimit initialOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final boolean includeHeaders;
    private volatile Set<TopicPartition> knownPartitions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public KafkaOffsetReader offsetReader() {
        return this.offsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    public Set<TopicPartition> knownPartitions() {
        return this.knownPartitions;
    }

    public void knownPartitions_$eq(Set<TopicPartition> x$1) {
        this.knownPartitions = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Offset initialOffset() {
        void var2_7;
        KafkaSourceOffset kafkaSourceOffset;
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = this.initialOffsets;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            kafkaSourceOffset = new KafkaSourceOffset(this.offsetReader().fetchEarliestOffsets());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            kafkaSourceOffset = new KafkaSourceOffset(this.offsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
            kafkaSourceOffset = this.offsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                this.reportDataLoss(message);
                return BoxedUnit.UNIT;
            });
        } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
            SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
            kafkaSourceOffset = this.offsetReader().fetchSpecificTimestampBasedOffsets(p, true);
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        KafkaSourceOffset offsets = kafkaSourceOffset;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
        return var2_7;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public InputPartition[] planInputPartitions(Offset start) {
        scala.collection.immutable.Map<TopicPartition, Object> oldStartPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        Set currentPartitionSet = this.offsetReader().fetchEarliestOffsets().keySet();
        Set newPartitions = (Set)currentPartitionSet.diff((GenSet)oldStartPartitionOffsets.keySet());
        scala.collection.immutable.Map<TopicPartition, Object> newPartitionOffsets = this.offsetReader().fetchEarliestOffsets((Seq<TopicPartition>)newPartitions.toSeq());
        Set deletedPartitions = (Set)oldStartPartitionOffsets.keySet().diff((GenSet)currentPartitionSet);
        if (deletedPartitions.nonEmpty()) {
            String message = this.offsetReader().driverKafkaParams().containsKey("group.id") ? new StringBuilder(11).append(deletedPartitions).append(" are gone. ").append(KafkaSourceProvider$.MODULE$.CUSTOM_GROUP_ID_ERROR_MESSAGE()).toString() : new StringBuilder(42).append(deletedPartitions).append(" are gone. Some data may have been missed.").toString();
            this.reportDataLoss(message);
        }
        scala.collection.immutable.Map startOffsets = newPartitionOffsets.$plus$plus((GenTraversableOnce)oldStartPartitionOffsets.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaContinuousStream.$anonfun$planInputPartitions$1(deletedPartitions, x$1))));
        this.knownPartitions_$eq((Set<TopicPartition>)startOffsets.keySet());
        return (InputPartition[])((TraversableOnce)startOffsets.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long start = tuple2._2$mcJ$sp();
            KafkaContinuousInputPartition kafkaContinuousInputPartition = new KafkaContinuousInputPartition(topicPartition, start, $this.kafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders());
            return kafkaContinuousInputPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public ContinuousPartitionReaderFactory createContinuousReaderFactory() {
        return KafkaContinuousReaderFactory$.MODULE$;
    }

    public synchronized void stop() {
        this.offsetReader().close();
    }

    public void commit(Offset end) {
    }

    public Offset mergeOffsets(PartitionOffset[] offsets) {
        scala.collection.immutable.Map mergedMap = (scala.collection.immutable.Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsets)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionOffset partitionOffset = x0$1;
            if (!(partitionOffset instanceof KafkaSourcePartitionOffset)) {
                throw new MatchError((Object)partitionOffset);
            }
            KafkaSourcePartitionOffset kafkaSourcePartitionOffset = (KafkaSourcePartitionOffset)partitionOffset;
            TopicPartition p = kafkaSourcePartitionOffset.topicPartition();
            long o = kafkaSourcePartitionOffset.partitionOffset();
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)BoxesRunTime.boxToLong((long)o))}));
            return map;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$plus$plus((GenTraversableOnce)x$3));
        return new KafkaSourceOffset((scala.collection.immutable.Map<TopicPartition, Object>)mergedMap);
    }

    public boolean needsReconfiguration() {
        Set set = this.offsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$).keySet();
        Set<TopicPartition> set2 = this.knownPartitions();
        return set == null ? set2 != null : !set.equals(set2);
    }

    public String toString() {
        return new StringBuilder(13).append("KafkaSource[").append(this.offsetReader()).append("]").toString();
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$1(Set deletedPartitions$1, TopicPartition x$1) {
        return !deletedPartitions$1.contains((Object)x$1);
    }

    public KafkaContinuousStream(KafkaOffsetReader offsetReader, Map<String, Object> kafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit initialOffsets, boolean failOnDataLoss) {
        this.offsetReader = offsetReader;
        this.kafkaParams = kafkaParams;
        this.initialOffsets = initialOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), 512L);
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

