/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.kafka010.KafkaRecordToRowConverter;
import org.apache.spark.sql.kafka010.KafkaSourcePartitionOffset;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\f\u0018\u0001\tB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003F\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\r\u0004A\u0011\u00013\t\u000f5\u0004!\u0019!C\u0005]\"1A\u000f\u0001Q\u0001\n=Dq!\u001e\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011B<\t\u0013\u0005E\u0001\u00011A\u0005\n\u0005M\u0001\"CA\u000b\u0001\u0001\u0007I\u0011BA\f\u0011\u001d\t\u0019\u0003\u0001Q!\n\u0015C1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(!Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0011-\tI\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000b\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003;\u0002A\u0011IA0\u0005yY\u0015MZ6b\u0007>tG/\u001b8v_V\u001c\b+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002\u00193\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G-\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004PE*,7\r\u001e\t\u0004YM*T\"A\u0017\u000b\u00059z\u0013!C:ue\u0016\fW.\u001b8h\u0015\t\u0001\u0014'\u0001\u0003sK\u0006$'B\u0001\u001a\u001a\u0003%\u0019wN\u001c8fGR|'/\u0003\u00025[\tI2i\u001c8uS:,x.^:QCJ$\u0018\u000e^5p]J+\u0017\rZ3s!\t1\u0014(D\u00018\u0015\tA\u0014$\u0001\u0005dCR\fG._:u\u0013\tQtGA\u0006J]R,'O\\1m%><\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baaY8n[>t'BA!\u001e\u0003\u0015Y\u0017MZ6b\u0013\t\u0019eH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0005\u0019>tw-A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003B'Q%\u000ej\u0011A\u0014\u0006\u0003\u001f\u001e\nA!\u001e;jY&\u0011\u0011K\u0014\u0002\u0004\u001b\u0006\u0004\bCA*[\u001d\t!\u0006\f\u0005\u0002V\u000f6\taK\u0003\u0002XC\u00051AH]8pizJ!!W$\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033\u001e\u000bQ\u0002]8mYRKW.Z8vi6\u001b\u0018A\u00044bS2|e\u000eR1uC2{7o\u001d\t\u0003\r\u0002L!!Y$\u0003\u000f\t{w\u000e\\3b]\u0006q\u0011N\\2mk\u0012,\u0007*Z1eKJ\u001c\u0018A\u0002\u001fj]&$h\bF\u0004fO\"L'n\u001b7\u0011\u0005\u0019\u0004Q\"A\f\t\u000bm:\u0001\u0019\u0001\u001f\t\u000b\u0011;\u0001\u0019A#\t\u000b-;\u0001\u0019\u0001'\t\u000bu;\u0001\u0019A#\t\u000by;\u0001\u0019A0\t\u000b\t<\u0001\u0019A0\u0002\u0011\r|gn];nKJ,\u0012a\u001c\t\u0003aJl\u0011!\u001d\u0006\u0003[^I!a]9\u0003#-\u000bgm[1ECR\f7i\u001c8tk6,'/A\u0005d_:\u001cX/\\3sA\u0005\u0011RO\\:bM\u0016\u0014vn\u001e)s_*,7\r^8s+\u00059\b#\u0002$yu\u0006\r\u0011BA=H\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002|}:\u0011a\r`\u0005\u0003{^\t\u0011dS1gW\u0006\u0014VmY8sIR{'k\\<D_:4XM\u001d;fe&\u0019q0!\u0001\u0003\rI+7m\u001c:e\u0015\tix\u0003\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaN\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002\u000e\u0005\u001d!!C+og\u00064WMU8x\u0003M)hn]1gKJ{w\u000f\u0015:pU\u0016\u001cGo\u001c:!\u0003=qW\r\u001f;LC\u001a\\\u0017m\u00144gg\u0016$X#A#\u0002'9,\u0007\u0010^&bM.\fwJ\u001a4tKR|F%Z9\u0015\t\u0005e\u0011q\u0004\t\u0004\r\u0006m\u0011bAA\u000f\u000f\n!QK\\5u\u0011!\t\t#DA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005\u0001b.\u001a=u\u0017\u000647.Y(gMN,G\u000fI\u0001\u000eGV\u0014(/\u001a8u%\u0016\u001cwN\u001d3\u0016\u0005\u0005%\u0002\u0003CA\u0016\u0003g\t9$a\u000e\u000e\u0005\u00055\"bA7\u00020)\u0019\u0011\u0011\u0007!\u0002\u000f\rd\u0017.\u001a8ug&!\u0011QGA\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004RARA\u001d\u0003{I1!a\u000fH\u0005\u0015\t%O]1z!\r1\u0015qH\u0005\u0004\u0003\u0003:%\u0001\u0002\"zi\u0016\f\u0011cY;se\u0016tGOU3d_J$w\fJ3r)\u0011\tI\"a\u0012\t\u0013\u0005\u0005\u0002#!AA\u0002\u0005%\u0012AD2veJ,g\u000e\u001e*fG>\u0014H\rI\u0001\u0005]\u0016DH\u000fF\u0001`\u0003\r9W\r\u001e\u000b\u0003\u0003\u0007\t\u0011bZ3u\u001f\u001a47/\u001a;\u0015\u0005\u0005]\u0003c\u00014\u0002Z%\u0019\u00111L\f\u00035-\u000bgm[1T_V\u00148-\u001a)beRLG/[8o\u001f\u001a47/\u001a;\u0002\u000b\rdwn]3\u0015\u0005\u0005e\u0001")
public class KafkaContinuousPartitionReader
implements ContinuousPartitionReader<InternalRow> {
    private final TopicPartition topicPartition;
    private final long pollTimeoutMs;
    private final boolean failOnDataLoss;
    private final KafkaDataConsumer consumer;
    private final Function1<ConsumerRecord<byte[], byte[]>, UnsafeRow> unsafeRowProjector;
    private long nextKafkaOffset;
    private ConsumerRecord<byte[], byte[]> currentRecord;

    private KafkaDataConsumer consumer() {
        return this.consumer;
    }

    private Function1<ConsumerRecord<byte[], byte[]>, UnsafeRow> unsafeRowProjector() {
        return this.unsafeRowProjector;
    }

    private long nextKafkaOffset() {
        return this.nextKafkaOffset;
    }

    private void nextKafkaOffset_$eq(long x$1) {
        this.nextKafkaOffset = x$1;
    }

    private ConsumerRecord<byte[], byte[]> currentRecord() {
        return this.currentRecord;
    }

    private void currentRecord_$eq(ConsumerRecord<byte[], byte[]> x$1) {
        this.currentRecord = x$1;
    }

    public boolean next() {
        ConsumerRecord<byte[], byte[]> r = null;
        while (r == null) {
            if (TaskContext$.MODULE$.get().isInterrupted() || TaskContext$.MODULE$.get().isCompleted()) {
                return false;
            }
            try {
                r = this.consumer().get(this.nextKafkaOffset(), Long.MAX_VALUE, this.pollTimeoutMs, this.failOnDataLoss);
            }
            catch (Throwable throwable) {
                IllegalStateException illegalStateException;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof java.util.concurrent.TimeoutException ? true : throwable2 instanceof TimeoutException;
                if (bl) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable2).getCause() instanceof OffsetOutOfRangeException) {
                    KafkaDataConsumer.AvailableOffsetRange range = this.consumer().getAvailableOffsetRange();
                    if (range.latest() < this.nextKafkaOffset() || range.earliest() > this.nextKafkaOffset()) {
                        throw illegalStateException;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.nextKafkaOffset_$eq(r.offset() + 1L);
        this.currentRecord_$eq(r);
        return true;
    }

    public UnsafeRow get() {
        return (UnsafeRow)this.unsafeRowProjector().apply(this.currentRecord());
    }

    public KafkaSourcePartitionOffset getOffset() {
        return new KafkaSourcePartitionOffset(this.topicPartition, this.nextKafkaOffset());
    }

    public void close() {
        this.consumer().release();
    }

    public KafkaContinuousPartitionReader(TopicPartition topicPartition, long startOffset, Map<String, Object> kafkaParams, long pollTimeoutMs, boolean failOnDataLoss, boolean includeHeaders) {
        this.topicPartition = topicPartition;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.consumer = KafkaDataConsumer$.MODULE$.acquire(topicPartition, kafkaParams);
        this.unsafeRowProjector = new KafkaRecordToRowConverter().toUnsafeRowProjector(includeHeaders);
        this.nextKafkaOffset = startOffset;
    }
}

