/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.KafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0007\u000f\u00019A\u0002\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002*\u0001!I!a\u000b\u0003\u001d-\u000bgm[1T_V\u00148-\u001a*E\t*\u0011q\u0002E\u0001\tW\u000647.\u0019\u00192a)\u0011\u0011CE\u0001\u0004gFd'BA\n\u0015\u0003\u0015\u0019\b/\u0019:l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0014\u0005\u0001I\u0002c\u0001\u000e\u001e?5\t1D\u0003\u0002\u001d%\u0005\u0019!\u000f\u001a3\n\u0005yY\"a\u0001*E\tB!\u0001eJ\u0015*\u001b\u0005\t#B\u0001\u0012$\u0003!\u0019wN\\:v[\u0016\u0014(B\u0001\u0013&\u0003\u001d\u0019G.[3oiNT!A\n\u000b\u0002\u000b-\fgm[1\n\u0005!\n#AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0004U5zS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\u0002\u0014BA\u0019,\u0005\u0011\u0011\u0015\u0010^3\u0002\u0005M\u001c7\u0001\u0001\t\u0003kYj\u0011AE\u0005\u0003oI\u0011Ab\u00159be.\u001cuN\u001c;fqR\f1#\u001a=fGV$xN]&bM.\f\u0007+\u0019:b[N\u0004BAO B\u00196\t1H\u0003\u0002={\u0005!Q\u000f^5m\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\u00075\u000b\u0007\u000f\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\t.j\u0011!\u0012\u0006\u0003\rN\na\u0001\u0010:p_Rt\u0014B\u0001%,\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005![\u0003CA'Q\u001b\u0005q%BA(>\u0003\u0011a\u0017M\\4\n\u0005Es%AB(cU\u0016\u001cG/\u0001\u0007pM\u001a\u001cX\r\u001e*b]\u001e,7\u000fE\u0002U3rs!!V,\u000f\u0005\u00113\u0016\"\u0001\u0017\n\u0005a[\u0013a\u00029bG.\fw-Z\u0005\u00035n\u00131aU3r\u0015\tA6\u0006\u0005\u0002^=6\ta\"\u0003\u0002`\u001d\tI2*\u00194lCN{WO]2f%\u0012#uJ\u001a4tKR\u0014\u0016M\\4f\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgB\u0011!FY\u0005\u0003G.\u0012A\u0001T8oO\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bC\u0001\u0016g\u0013\t97FA\u0004C_>dW-\u00198\u0002%I,Wo]3LC\u001a\\\u0017mQ8ogVlWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f-dWN\\8qcB\u0011Q\f\u0001\u0005\u0006e\u001d\u0001\r\u0001\u000e\u0005\u0006q\u001d\u0001\r!\u000f\u0005\u0006%\u001e\u0001\ra\u0015\u0005\u0006A\u001e\u0001\r!\u0019\u0005\u0006I\u001e\u0001\r!\u001a\u0005\u0006Q\u001e\u0001\r!Z\u0001\ba\u0016\u00148/[:u)\t!X/D\u0001\u0001\u0011\u00151\b\u00021\u0001x\u0003!qWm\u001e'fm\u0016d\u0007C\u0001=|\u001b\u0005I(B\u0001>\u0013\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001`=\u0003\u0019M#xN]1hK2+g/\u001a7\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\u0005y\b\u0003\u0002\u0016.\u0003\u0003\u00012!NA\u0002\u0013\r\t)A\u0005\u0002\n!\u0006\u0014H/\u001b;j_:\fQcZ3u!J,g-\u001a:sK\u0012dunY1uS>t7\u000f\u0006\u0003\u0002\f\u00055\u0001c\u0001+Z\u0003\"9\u0011q\u0002\u0006A\u0002\u0005\u0005\u0011!B:qY&$\u0018aB2p[B,H/\u001a\u000b\u0007\u0003+\tY\"a\b\u0011\tQ\u000b9bH\u0005\u0004\u00033Y&\u0001C%uKJ\fGo\u001c:\t\u000f\u0005u1\u00021\u0001\u0002\u0002\u00059A\u000f[3QCJ$\bbBA\u0011\u0017\u0001\u0007\u00111E\u0001\bG>tG/\u001a=u!\r)\u0014QE\u0005\u0004\u0003O\u0011\"a\u0003+bg.\u001cuN\u001c;fqR\fAB]3t_24XMU1oO\u0016$R\u0001XA\u0017\u0003kAaA\t\u0007A\u0002\u0005=\u0002cA/\u00022%\u0019\u00111\u0007\b\u0003#-\u000bgm[1ECR\f7i\u001c8tk6,'\u000f\u0003\u0004\u000281\u0001\r\u0001X\u0001\u0006e\u0006tw-\u001a")
public class KafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    private final Map<String, Object> executorKafkaParams;
    private final Seq<KafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss;
    private final boolean reuseKafkaConsumer;

    public KafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return (KafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            KafkaSourceRDDOffsetRange o = (KafkaSourceRDDOffsetRange)tuple2._1();
            int i = tuple2._2$mcI$sp();
            KafkaSourceRDDPartition kafkaSourceRDDPartition = new KafkaSourceRDDPartition(i, o);
            return kafkaSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        KafkaSourceRDDPartition part = (KafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        Object object;
        KafkaSourceRDDPartition sourcePartition = (KafkaSourceRDDPartition)thePart;
        KafkaDataConsumer consumer = KafkaDataConsumer$.MODULE$.acquire(sourcePartition.offsetRange().topicPartition(), this.executorKafkaParams, this.reuseKafkaConsumer);
        KafkaSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(147).append("Beginning offset ").append(range.fromOffset()).append(" is after the ending offset ").append(range.untilOffset()).append(" ").append("for topic ").append(range.topic()).append(" partition ").append(range.partition()).append(". ").append("You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString());
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Beginning offset ").append(range.fromOffset()).append(" is the same as ending offset ").append("skipping ").append(range.topic()).append(" ").append(range.partition()).toString());
            consumer.release();
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<ConsumerRecord<byte[], byte[]>> underlying = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, range, consumer){
                private long requestOffset;
                private final /* synthetic */ KafkaSourceRDD $outer;
                private final KafkaSourceRDDOffsetRange range$1;
                private final KafkaDataConsumer consumer$1;

                public long requestOffset() {
                    return this.requestOffset;
                }

                public void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public ConsumerRecord<byte[], byte[]> getNext() {
                    Object v0;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        v0 = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            v0 = null;
                        } else {
                            void var1_1;
                            this.requestOffset_$eq(r.offset() + 1L);
                            v0 = var1_1;
                        }
                    }
                    return v0;
                }

                public void close() {
                    this.consumer$1.release();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.range$1 = range$1;
                    this.consumer$1 = consumer$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener(arg_0 -> KafkaSourceRDD.$anonfun$compute$3$adapted((NextIterator)underlying, arg_0));
            object = underlying;
        }
        return object;
    }

    private KafkaSourceRDDOffsetRange resolveRange(KafkaDataConsumer consumer, KafkaSourceRDDOffsetRange range) {
        KafkaSourceRDDOffsetRange kafkaSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            KafkaDataConsumer.AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == KafkaOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("earliest offset ").append(range.fromOffset()).append(" does not equal ").append(KafkaOffsetRangeLimit$.MODULE$.EARLIEST()).toString());
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == KafkaOffsetRangeLimit$.MODULE$.LATEST(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("latest offset ").append(range.untilOffset()).append(" does not equal ").append(KafkaOffsetRangeLimit$.MODULE$.LATEST()).toString());
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            kafkaSourceRDDOffsetRange = new KafkaSourceRDDOffsetRange(range.topicPartition(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            kafkaSourceRDDOffsetRange = range;
        }
        return kafkaSourceRDDOffsetRange;
    }

    public KafkaSourceRDD(SparkContext sc, Map<String, Object> executorKafkaParams, Seq<KafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss, boolean reuseKafkaConsumer) {
        this.executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$KafkaSourceRDD$$failOnDataLoss = failOnDataLoss;
        this.reuseKafkaConsumer = reuseKafkaConsumer;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public static final /* synthetic */ Object $anonfun$compute$3$adapted(NextIterator underlying$1, TaskContext x$2) {
        underlying$1.closeIfNeeded();
        return BoxedUnit.UNIT;
    }
}

