/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaOffsetReader$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\t\u0012\u0001EY\u0002\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011I\u0017\t\u0011I\u0002!\u0011!Q\u0001\n9B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0011\n\u0001B\u0001B\u0003%\u0011\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000bQ\u0003A\u0011A+\t\u000fy\u0003!\u0019!C\u0005?\"11\r\u0001Q\u0001\n\u0001DQ\u0001\u001a\u0001\u0005B\u0015DQ\u0001\u001c\u0001\u0005B5DQa\u001e\u0001\u0005\naDq!a\u0005\u0001\t\u0003\n)BA\u0007LC\u001a\\\u0017MU3mCRLwN\u001c\u0006\u0003%M\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0003\u0002\u0001\u001dE\u0015\u0002\"!\b\u0011\u000e\u0003yQ!aH\n\u0002\u000fM|WO]2fg&\u0011\u0011E\b\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\t\u0003;\rJ!\u0001\n\u0010\u0003\u0013Q\u000b'\r\\3TG\u0006t\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0016\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0016(\u0005\u001daunZ4j]\u001e\f!b]9m\u0007>tG/\u001a=u\u0007\u0001)\u0012A\f\t\u0003_Aj\u0011aE\u0005\u0003cM\u0011!bU)M\u0007>tG/\u001a=u\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\u0002\u0011M$(/\u0019;fOf\u0004\"!\u000e\u001c\u000e\u0003EI!aN\t\u0003!\r{gn];nKJ\u001cFO]1uK\u001eL\u0018!D:pkJ\u001cWm\u00149uS>t7\u000f\u0005\u0003;\u0007\u001a3eBA\u001eB!\tat(D\u0001>\u0015\tqD&\u0001\u0004=e>|GO\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!iP\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%aA'ba*\u0011!i\u0010\t\u0003u\u001dK!\u0001S#\u0003\rM#(/\u001b8h\u0003Q\u0019\b/Z2jM&,GmS1gW\u0006\u0004\u0016M]1ng\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bC\u0001'N\u001b\u0005y\u0014B\u0001(@\u0005\u001d\u0011un\u001c7fC:\fqb\u001d;beRLgnZ(gMN,Go\u001d\t\u0003kEK!AU\t\u0003+-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,G*[7ji\u0006iQM\u001c3j]\u001e|eMZ:fiN\fa\u0001P5oSRtD\u0003\u0003,X1fS6\fX/\u0011\u0005U\u0002\u0001\"B\u0016\n\u0001\u0004q\u0003\"B\u001a\n\u0001\u0004!\u0004\"\u0002\u001d\n\u0001\u0004I\u0004\"B%\n\u0001\u0004I\u0004\"\u0002&\n\u0001\u0004Y\u0005\"B(\n\u0001\u0004\u0001\u0006\"B*\n\u0001\u0004\u0001\u0016!\u00049pY2$\u0016.\\3pkRl5/F\u0001a!\ta\u0015-\u0003\u0002c\u007f\t!Aj\u001c8h\u00039\u0001x\u000e\u001c7US6,w.\u001e;Ng\u0002\naa]2iK6\fW#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u001c\u0012!\u0002;za\u0016\u001c\u0018BA6i\u0005)\u0019FO];diRK\b/Z\u0001\nEVLG\u000eZ*dC:$\u0012A\u001c\t\u0004_J$X\"\u00019\u000b\u0005E,\u0012a\u0001:eI&\u00111\u000f\u001d\u0002\u0004%\u0012#\u0005CA\u0018v\u0013\t18CA\u0002S_^\f1cZ3u!\u0006\u0014H/\u001b;j_:|eMZ:fiN$R!_A\u0003\u0003\u001f\u0001BAO\"{AB\u001910!\u0001\u000e\u0003qT!! @\u0002\r\r|W.\\8o\u0015\tyx#A\u0003lC\u001a\\\u0017-C\u0002\u0002\u0004q\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\b9\u0001\r!!\u0003\u0002\u0017-\fgm[1SK\u0006$WM\u001d\t\u0004k\u0005-\u0011bAA\u0007#\t\t2*\u00194lC>3gm]3u%\u0016\fG-\u001a:\t\r\u0005Ea\u00021\u0001Q\u00031Y\u0017MZ6b\u001f\u001a47/\u001a;t\u0003!!xn\u0015;sS:<G#\u0001$")
public class KafkaRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final ConsumerStrategy strategy;
    private final scala.collection.immutable.Map<String, String> sourceOptions;
    private final scala.collection.immutable.Map<String, String> specifiedKafkaParams;
    private final boolean failOnDataLoss;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public StructType schema() {
        return KafkaOffsetReader$.MODULE$.kafkaSchema();
    }

    public RDD<Row> buildScan() {
        Tuple2 tuple2;
        String uniqueGroupId = new StringBuilder(21).append("spark-kafka-relation-").append(UUID.randomUUID()).toString();
        try (KafkaOffsetReader kafkaOffsetReader = new KafkaOffsetReader(this.strategy, KafkaSourceProvider$.MODULE$.kafkaParamsForDriver(this.specifiedKafkaParams), this.sourceOptions, new StringBuilder(7).append(uniqueGroupId).append("-driver").toString());){
            tuple2 = new Tuple2(this.getPartitionOffsets(kafkaOffsetReader, this.startingOffsets), this.getPartitionOffsets(kafkaOffsetReader, this.endingOffsets));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        scala.collection.immutable.Map fromPartitionOffsets = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map untilPartitionOffsets = (scala.collection.immutable.Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)fromPartitionOffsets, (Object)untilPartitionOffsets);
        Tuple2 tuple24 = tuple23;
        scala.collection.immutable.Map fromPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map untilPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._2();
        Set set = fromPartitionOffsets2.keySet();
        Set set2 = untilPartitionOffsets2.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(84).append("different topic partitions ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(untilTopics).append("]").toString());
        }
        KafkaSourceRDDOffsetRange[] offsetRanges = (KafkaSourceRDDOffsetRange[])((TraversableOnce)untilPartitionOffsets2.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets2.get(tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets2.apply(tp));
            return new KafkaSourceRDDOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaSourceRDDOffsetRange.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetRanges)).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$))).mkString(", ")).toString());
        Map<String, Object> executorKafkaParams = KafkaSourceProvider$.MODULE$.kafkaParamsForExecutors(this.specifiedKafkaParams, uniqueGroupId);
        RDD rdd = new KafkaSourceRDD(this.sqlContext().sparkContext(), executorKafkaParams, (Seq<KafkaSourceRDDOffsetRange>)Predef$.MODULE$.wrapRefArray((Object[])offsetRanges), this.pollTimeoutMs(), this.failOnDataLoss, false).map((Function1 & Serializable & scala.Serializable)cr -> InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cr.key(), cr.value(), UTF8String.fromString((String)cr.topic()), BoxesRunTime.boxToInteger((int)cr.partition()), BoxesRunTime.boxToLong((long)cr.offset()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.timestamp()))), BoxesRunTime.boxToInteger((int)cr.timestampType().id)})), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sqlContext().internalCreateDataFrame(rdd.setName("kafka"), this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getPartitionOffsets(KafkaOffsetReader kafkaReader, KafkaOffsetRangeLimit kafkaOffsets) {
        scala.collection.immutable.Map map;
        Set<TopicPartition> partitions = kafkaReader.fetchTopicPartitions();
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = kafkaOffsets;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            map = this.validateTopicPartitions$1(partitions, partitionOffsets);
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        return map;
    }

    public String toString() {
        return new StringBuilder(38).append("KafkaRelation(strategy=").append(this.strategy).append(", start=").append(this.startingOffsets).append(", end=").append(this.endingOffsets).append(")").toString();
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(Set partitions, scala.collection.immutable.Map partitionOffsets) {
        Set set = partitions;
        Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public KafkaRelation(SQLContext sqlContext, ConsumerStrategy strategy, scala.collection.immutable.Map<String, String> sourceOptions, scala.collection.immutable.Map<String, String> specifiedKafkaParams, boolean failOnDataLoss, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.strategy = strategy;
        this.sourceOptions = sourceOptions;
        this.specifiedKafkaParams = specifiedKafkaParams;
        this.failOnDataLoss = failOnDataLoss;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit == null ? latestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Starting offset not allowed to be set to latest offsets.");
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 == null ? earliestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Ending offset not allowed to be set to earliest offsets.");
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)"kafkaConsumer.pollTimeoutMs", (Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToLong((long)(this.sqlContext().sparkContext().conf().getTimeAsSeconds("spark.network.timeout", "120s") * 1000L))).toString()))).toLong();
    }
}

