/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.sql.Timestamp;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00053Q!\u0002\u0004\u0001\rAAQa\u0006\u0001\u0005\u0002eAq\u0001\b\u0001C\u0002\u0013%Q\u0004\u0003\u0004)\u0001\u0001\u0006IA\b\u0005\u0006S\u0001!\tA\u000b\u0002 \u0017\u000647.\u0019*fG>\u0014H\rV8V]N\fg-\u001a*po\u000e{gN^3si\u0016\u0014(BA\u0004\t\u0003!Y\u0017MZ6baE\u0002$BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sON\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0007\t\u00037\u0001i\u0011AB\u0001\ne><xK]5uKJ,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nqaY8eK\u001e,gN\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)\u0003\"\u0001\u0005dCR\fG._:u\u0013\t9\u0003EA\bV]N\fg-\u001a*po^\u0013\u0018\u000e^3s\u0003)\u0011xn^,sSR,'\u000fI\u0001\fi>,fn]1gKJ{w\u000f\u0006\u0002,_A\u0011A&L\u0007\u0002E%\u0011aF\t\u0002\n+:\u001c\u0018MZ3S_^DQ\u0001\r\u0003A\u0002E\naA]3d_J$\u0007\u0003\u0002\u001a:wmj\u0011a\r\u0006\u0003iU\n\u0001bY8ogVlWM\u001d\u0006\u0003m]\nqa\u00197jK:$8O\u0003\u00029\u0019\u0005)1.\u00194lC&\u0011!h\r\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\r\u0011BHP\u0005\u0003{M\u0011Q!\u0011:sCf\u0004\"AE \n\u0005\u0001\u001b\"\u0001\u0002\"zi\u0016\u0004")
public class KafkaRecordToUnsafeRowConverter {
    private final UnsafeRowWriter rowWriter = new UnsafeRowWriter(7);

    private UnsafeRowWriter rowWriter() {
        return this.rowWriter;
    }

    public UnsafeRow toUnsafeRow(ConsumerRecord<byte[], byte[]> record) {
        this.rowWriter().reset();
        this.rowWriter().zeroOutNullBytes();
        if (record.key() == null) {
            this.rowWriter().setNullAt(0);
        } else {
            this.rowWriter().write(0, (byte[])record.key());
        }
        if (record.value() == null) {
            this.rowWriter().setNullAt(1);
        } else {
            this.rowWriter().write(1, (byte[])record.value());
        }
        this.rowWriter().write(2, UTF8String.fromString((String)record.topic()));
        this.rowWriter().write(3, record.partition());
        this.rowWriter().write(4, record.offset());
        this.rowWriter().write(5, DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(record.timestamp())));
        this.rowWriter().write(6, record.timestampType().id);
        return this.rowWriter().getRow();
    }
}

