/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q4Qa\u0003\u0007\u0001\u0019YA\u0001\"\b\u0001\u0003\u0006\u0004%\ta\b\u0005\tM\u0001\u0011\t\u0011)A\u0005A!)q\u0005\u0001C\u0001Q!)A\u0006\u0001C\u0001[!9!\u000bAI\u0001\n\u0003\u0019\u0006\"\u00020\u0001\t\u0013yvA\u00027\r\u0011\u0003aQN\u0002\u0004\f\u0019!\u0005AB\u001c\u0005\u0006O!!\ta\u001c\u0005\u0006a\"!\t!\u001d\u0002\u001b\u0017\u000647.Y(gMN,GOU1oO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003\u001b9\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006iQ.\u001b8QCJ$\u0018\u000e^5p]N\u001c\u0001!F\u0001!!\rA\u0012eI\u0005\u0003Ee\u0011aa\u00149uS>t\u0007C\u0001\r%\u0013\t)\u0013DA\u0002J]R\fa\"\\5o!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u00031AQ!H\u0002A\u0002\u0001\n\u0011bZ3u%\u0006tw-Z:\u0015\t9jTi\u0012\t\u0004_]RdB\u0001\u00196\u001d\t\tD'D\u00013\u0015\t\u0019d$\u0001\u0004=e>|GOP\u0005\u00025%\u0011a'G\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014HA\u0002TKFT!AN\r\u0011\u0005)Z\u0014B\u0001\u001f\r\u0005AY\u0015MZ6b\u001f\u001a47/\u001a;SC:<W\rC\u0003?\t\u0001\u0007q(A\u0006ge>lwJ\u001a4tKR\u001c\bC\u0001!C\u001d\tQ\u0013)\u0003\u00027\u0019%\u00111\t\u0012\u0002\u0013!\u0006\u0014H/\u001b;j_:|eMZ:fi6\u000b\u0007O\u0003\u00027\u0019!)a\t\u0002a\u0001\u007f\u0005aQO\u001c;jY>3gm]3ug\"9\u0001\n\u0002I\u0001\u0002\u0004I\u0015!E3yK\u000e,Ho\u001c:M_\u000e\fG/[8ogB\u0019qf\u000e&\u0011\u0005-{eB\u0001'N!\t\t\u0014$\u0003\u0002O3\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0015$A\nhKR\u0014\u0016M\\4fg\u0012\"WMZ1vYR$3'F\u0001UU\tIUkK\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0005v]\u000eDWmY6fI*\u00111,G\u0001\u000bC:tw\u000e^1uS>t\u0017BA/Y\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\fO\u0016$Hj\\2bi&|g\u000eF\u0002aC.\u00042\u0001G\u0011K\u0011\u0015\u0011g\u00011\u0001d\u0003\t!\b\u000f\u0005\u0002eS6\tQM\u0003\u0002gO\u000611m\\7n_:T!\u0001\u001b\n\u0002\u000b-\fgm[1\n\u0005),'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u0011\u001a\u0001\r!S\u0001\u001b\u0017\u000647.Y(gMN,GOU1oO\u0016\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003U!\u0019\"\u0001C\f\u0015\u00035\fQ!\u00199qYf$\"!\u000b:\t\u000bMT\u0001\u0019\u0001;\u0002\u000f=\u0004H/[8ogB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0003mJR!!\u001f\b\u0002\u000fM|WO]2fg&\u00111P\u001e\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\b")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;

    public static KafkaOffsetRangeCalculator apply(DataSourceOptions dataSourceOptions) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(dataSourceOptions);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Seq<KafkaOffsetRange> getRanges(Map<TopicPartition, Object> fromOffsets, Map<TopicPartition, Object> untilOffsets, Seq<String> executorLocations) {
        Seq seq;
        Set partitionsToRead = (Set)untilOffsets.keySet().intersect((GenSet)fromOffsets.keySet());
        Seq offsetRanges = (Seq)((TraversableLike)partitionsToRead.toSeq().map((Function1 & Serializable & scala.Serializable)tp -> new KafkaOffsetRange((TopicPartition)tp, BoxesRunTime.unboxToLong((Object)fromOffsets.apply(tp)), BoxesRunTime.unboxToLong((Object)untilOffsets.apply(tp)), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$2(x$1)));
        if (this.minPartitions().isEmpty() || offsetRanges.size() > BoxesRunTime.unboxToInt((Object)this.minPartitions().get())) {
            seq = (Seq)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> {
                Option<String> x$1 = this.getLocation(range.topicPartition(), executorLocations);
                TopicPartition x$2 = range.copy$default$1();
                long x$3 = range.copy$default$2();
                long x$4 = range.copy$default$3();
                return range.copy(x$2, x$3, x$4, x$1);
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            seq = (Seq)((TraversableLike)offsetRanges.flatMap((Function1 & Serializable & scala.Serializable)range -> {
                TopicPartition tp = range.topicPartition();
                long size = range.size();
                int parts = (int)package$.MODULE$.max(package$.MODULE$.round((double)size / (double)totalSize * (double)BoxesRunTime.unboxToInt((Object)this.minPartitions().get())), 1L);
                LongRef remaining = LongRef.create((long)size);
                LongRef startOffset = LongRef.create((long)range.fromOffset());
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).map((Function1 & Serializable & scala.Serializable)part -> KafkaOffsetRangeCalculator.$anonfun$getRanges$6(remaining, parts, startOffset, range, tp, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$7(x$3)));
        }
        return seq;
    }

    public Seq<String> getRanges$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        return numExecutors > 0 ? new Some(executorLocations.apply(KafkaOffsetRangeCalculator.floorMod$1(tp.hashCode(), numExecutors))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$2(KafkaOffsetRange x$1) {
        return x$1.size() > 0L;
    }

    public static final /* synthetic */ KafkaOffsetRange $anonfun$getRanges$6(LongRef remaining$1, int parts$1, LongRef startOffset$1, KafkaOffsetRange range$1, TopicPartition tp$1, int part) {
        long thisPartition = remaining$1.elem / (long)(parts$1 - part);
        remaining$1.elem -= thisPartition;
        long endOffset = package$.MODULE$.min(startOffset$1.elem + thisPartition, range$1.untilOffset());
        KafkaOffsetRange offsetRange = new KafkaOffsetRange(tp$1, startOffset$1.elem, endOffset, (Option<String>)None$.MODULE$);
        startOffset$1.elem = endOffset;
        return offsetRange;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$7(KafkaOffsetRange x$3) {
        return x$3.size() > 0L;
    }

    private static final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions) {
        this.minPartitions = minPartitions;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt((Object)minPartitions.get()) > 0);
    }
}

