/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;

public final class KafkaDataConsumer$
implements Logging {
    public static KafkaDataConsumer$ MODULE$;
    private LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new KafkaDataConsumer$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> cache$lzycompute() {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.kafkaConsumerCache.capacity", 64);
                this.cache = new LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer>(capacity){
                    private final int capacity$1;

                    public boolean removeEldestEntry(Map.Entry<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> entry) {
                        boolean bl;
                        if (!entry.getValue().inUse() && this.size() > this.capacity$1) {
                            KafkaDataConsumer$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("KafkaConsumer cache hitting max capacity of ").append($this.capacity$1).append(", ").append("removing consumer for ").append(entry.getKey()).toString());
                            try {
                                entry.getValue().close();
                            }
                            catch (SparkException e) {
                                KafkaDataConsumer$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error closing earliest Kafka consumer for ").append(entry.getKey()).toString(), e);
                            }
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$removeEldestEntry$1(org.apache.spark.sql.kafka010.KafkaDataConsumer$$anon$1 java.util.Map$Entry ), $anonfun$removeEldestEntry$2(java.util.Map$Entry )}, serializedLambda);
                    }
                };
                this.bitmap$0 = true;
            }
        }
        return this.cache;
    }

    private LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> cache() {
        return !this.bitmap$0 ? this.cache$lzycompute() : this.cache;
    }

    public synchronized KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> kafkaParams, boolean useCache) {
        Product product;
        LazyRef newInternalConsumer$lzy = new LazyRef();
        KafkaDataConsumer.CacheKey key = new KafkaDataConsumer.CacheKey(topicPartition, kafkaParams);
        InternalKafkaConsumer existingInternalConsumer = this.cache().get(key);
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() >= 1) {
            if (existingInternalConsumer != null) {
                if (existingInternalConsumer.inUse()) {
                    existingInternalConsumer.markedForClose_$eq(true);
                } else {
                    existingInternalConsumer.close();
                }
            }
            this.cache().remove(key);
            product = new KafkaDataConsumer.NonCachedKafkaDataConsumer(KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams));
        } else if (!useCache) {
            product = new KafkaDataConsumer.NonCachedKafkaDataConsumer(KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams));
        } else if (existingInternalConsumer == null) {
            this.cache().put(key, KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams));
            KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams).inUse_$eq(true);
            product = new KafkaDataConsumer.CachedKafkaDataConsumer(KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams));
        } else if (existingInternalConsumer.inUse()) {
            product = new KafkaDataConsumer.NonCachedKafkaDataConsumer(KafkaDataConsumer$.newInternalConsumer$1(newInternalConsumer$lzy, topicPartition, kafkaParams));
        } else {
            existingInternalConsumer.inUse_$eq(true);
            product = new KafkaDataConsumer.CachedKafkaDataConsumer(existingInternalConsumer);
        }
        return product;
    }

    public void org$apache$spark$sql$kafka010$KafkaDataConsumer$$release(InternalKafkaConsumer intConsumer) {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            Object object;
            KafkaDataConsumer.CacheKey key = new KafkaDataConsumer.CacheKey(intConsumer.topicPartition(), intConsumer.kafkaParams());
            InternalKafkaConsumer cachedIntConsumer = this.cache().get(key);
            if (intConsumer == cachedIntConsumer) {
                if (intConsumer.markedForClose()) {
                    intConsumer.close();
                    object = this.cache().remove(key);
                } else {
                    intConsumer.inUse_$eq(false);
                    object = BoxedUnit.UNIT;
                }
            } else {
                intConsumer.close();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Released a supposedly cached consumer that was not found in the cache");
                object = BoxedUnit.UNIT;
            }
        }
    }

    private static final /* synthetic */ InternalKafkaConsumer newInternalConsumer$lzycompute$1(LazyRef newInternalConsumer$lzy$1, TopicPartition topicPartition$1, Map kafkaParams$1) {
        InternalKafkaConsumer internalKafkaConsumer;
        LazyRef lazyRef = newInternalConsumer$lzy$1;
        synchronized (lazyRef) {
            internalKafkaConsumer = newInternalConsumer$lzy$1.initialized() ? (InternalKafkaConsumer)newInternalConsumer$lzy$1.value() : (InternalKafkaConsumer)newInternalConsumer$lzy$1.initialize((Object)new InternalKafkaConsumer(topicPartition$1, kafkaParams$1));
        }
        return internalKafkaConsumer;
    }

    private static final InternalKafkaConsumer newInternalConsumer$1(LazyRef newInternalConsumer$lzy$1, TopicPartition topicPartition$1, Map kafkaParams$1) {
        return newInternalConsumer$lzy$1.initialized() ? (InternalKafkaConsumer)newInternalConsumer$lzy$1.value() : KafkaDataConsumer$.newInternalConsumer$lzycompute$1(newInternalConsumer$lzy$1, topicPartition$1, kafkaParams$1);
    }

    private KafkaDataConsumer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

