/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaRecordToUnsafeRowConverter;
import org.apache.spark.sql.kafka010.KafkaSourcePartitionOffset;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousInputPartitionReader;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003G\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\"B2\u0001\t\u0003!\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000fI\u0004!\u0019!C\u0005g\"1q\u000f\u0001Q\u0001\nQDq\u0001\u001f\u0001A\u0002\u0013%\u0011\u0010C\u0004{\u0001\u0001\u0007I\u0011B>\t\u000f\u0005\r\u0001\u0001)Q\u0005\r\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0004\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0002\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002J\u0001!\t%a\u0013\u0003G-\u000bgm[1D_:$\u0018N\\;pkNLe\u000e];u!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe*\u0011q\u0003G\u0001\tW\u000647.\u0019\u00192a)\u0011\u0011DG\u0001\u0004gFd'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\t\u0016\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t1qJ\u00196fGR\u00042a\u000b\u001b7\u001b\u0005a#BA\u0017/\u0003%\u0019HO]3b[&twM\u0003\u00020a\u00051!/Z1eKJT!!\r\u001a\u0002\u0005Y\u0014$BA\u001a\u0019\u0003\u001d\u0019x.\u001e:dKNL!!\u000e\u0017\u0003=\r{g\u000e^5ok>,8/\u00138qkR\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014\bCA\u001c;\u001b\u0005A$BA\u001d\u0019\u0003!\u0019\u0017\r^1msN$\u0018BA\u001e9\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u0005\tc\u0012!B6bM.\f\u0017B\u0001#@\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1b\u001d;beR|eMZ:fiB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n!Aj\u001c8h\u0003-Y\u0017MZ6b!\u0006\u0014\u0018-\\:\u0011\t9\u000b6KI\u0007\u0002\u001f*\u0011\u0001KJ\u0001\u0005kRLG.\u0003\u0002S\u001f\n\u0019Q*\u00199\u0011\u0005Q[fBA+Z!\t1\u0006*D\u0001X\u0015\tA\u0006%\u0001\u0004=e>|GOP\u0005\u00035\"\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!\fS\u0001\u000ea>dG\u000eV5nK>,H/T:\u0002\u001d\u0019\f\u0017\u000e\\(o\t\u0006$\u0018\rT8tgB\u0011q)Y\u0005\u0003E\"\u0013qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0007K\u001eD\u0017N[6\u0011\u0005\u0019\u0004Q\"\u0001\f\t\u000bq2\u0001\u0019A\u001f\t\u000b\u00153\u0001\u0019\u0001$\t\u000b13\u0001\u0019A'\t\u000by3\u0001\u0019\u0001$\t\u000b}3\u0001\u0019\u00011\u0002\u0011\r|gn];nKJ,\u0012A\u001c\t\u0003M>L!\u0001\u001d\f\u0003#-\u000bgm[1ECR\f7i\u001c8tk6,'/A\u0005d_:\u001cX/\\3sA\u0005I1m\u001c8wKJ$XM]\u000b\u0002iB\u0011a-^\u0005\u0003mZ\u0011qdS1gW\u0006\u0014VmY8sIR{WK\\:bM\u0016\u0014vn^\"p]Z,'\u000f^3s\u0003)\u0019wN\u001c<feR,'\u000fI\u0001\u0010]\u0016DHoS1gW\u0006|eMZ:fiV\ta)A\noKb$8*\u00194lC>3gm]3u?\u0012*\u0017\u000f\u0006\u0002}\u007fB\u0011q)`\u0005\u0003}\"\u0013A!\u00168ji\"A\u0011\u0011\u0001\u0007\u0002\u0002\u0003\u0007a)A\u0002yIE\n\u0001C\\3yi.\u000bgm[1PM\u001a\u001cX\r\u001e\u0011\u0002\u001b\r,(O]3oiJ+7m\u001c:e+\t\tI\u0001\u0005\u0005\u0002\f\u0005M\u0011qCA\f\u001b\t\tiAC\u0002m\u0003\u001fQ1!!\u0005B\u0003\u001d\u0019G.[3oiNLA!!\u0006\u0002\u000e\tq1i\u001c8tk6,'OU3d_J$\u0007#B$\u0002\u001a\u0005u\u0011bAA\u000e\u0011\n)\u0011I\u001d:bsB\u0019q)a\b\n\u0007\u0005\u0005\u0002J\u0001\u0003CsR,\u0017!E2veJ,g\u000e\u001e*fG>\u0014Hm\u0018\u0013fcR\u0019A0a\n\t\u0013\u0005\u0005q\"!AA\u0002\u0005%\u0011AD2veJ,g\u000e\u001e*fG>\u0014H\rI\u0001\u0005]\u0016DH\u000fF\u0001a\u0003\r9W\r\u001e\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0014aC3yaJ,7o]5p]NLA!!\u0010\u00028\tIQK\\:bM\u0016\u0014vn^\u0001\nO\u0016$xJ\u001a4tKR$\"!a\u0011\u0011\u0007\u0019\f)%C\u0002\u0002HY\u0011!dS1gW\u0006\u001cv.\u001e:dKB\u000b'\u000f^5uS>twJ\u001a4tKR\fQa\u00197pg\u0016$\u0012\u0001 ")
public class KafkaContinuousInputPartitionReader
implements ContinuousInputPartitionReader<InternalRow> {
    private final TopicPartition topicPartition;
    private final long pollTimeoutMs;
    private final boolean failOnDataLoss;
    private final KafkaDataConsumer consumer;
    private final KafkaRecordToUnsafeRowConverter converter;
    private long nextKafkaOffset;
    private ConsumerRecord<byte[], byte[]> currentRecord;

    private KafkaDataConsumer consumer() {
        return this.consumer;
    }

    private KafkaRecordToUnsafeRowConverter converter() {
        return this.converter;
    }

    private long nextKafkaOffset() {
        return this.nextKafkaOffset;
    }

    private void nextKafkaOffset_$eq(long x$1) {
        this.nextKafkaOffset = x$1;
    }

    private ConsumerRecord<byte[], byte[]> currentRecord() {
        return this.currentRecord;
    }

    private void currentRecord_$eq(ConsumerRecord<byte[], byte[]> x$1) {
        this.currentRecord = x$1;
    }

    public boolean next() {
        ConsumerRecord<byte[], byte[]> r = null;
        while (r == null) {
            if (TaskContext$.MODULE$.get().isInterrupted() || TaskContext$.MODULE$.get().isCompleted()) {
                return false;
            }
            try {
                r = this.consumer().get(this.nextKafkaOffset(), Long.MAX_VALUE, this.pollTimeoutMs, this.failOnDataLoss);
            }
            catch (Throwable throwable) {
                IllegalStateException illegalStateException;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof java.util.concurrent.TimeoutException ? true : throwable2 instanceof TimeoutException;
                if (bl) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable2).getCause() instanceof OffsetOutOfRangeException) {
                    KafkaDataConsumer.AvailableOffsetRange range = this.consumer().getAvailableOffsetRange();
                    if (range.latest() < this.nextKafkaOffset() || range.earliest() > this.nextKafkaOffset()) {
                        throw illegalStateException;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.nextKafkaOffset_$eq(r.offset() + 1L);
        this.currentRecord_$eq(r);
        return true;
    }

    public UnsafeRow get() {
        return this.converter().toUnsafeRow(this.currentRecord());
    }

    public KafkaSourcePartitionOffset getOffset() {
        return new KafkaSourcePartitionOffset(this.topicPartition, this.nextKafkaOffset());
    }

    public void close() {
        this.consumer().release();
    }

    public KafkaContinuousInputPartitionReader(TopicPartition topicPartition, long startOffset, Map<String, Object> kafkaParams, long pollTimeoutMs, boolean failOnDataLoss) {
        this.topicPartition = topicPartition;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.consumer = KafkaDataConsumer$.MODULE$.acquire(topicPartition, kafkaParams, false);
        this.converter = new KafkaRecordToUnsafeRowConverter();
        this.nextKafkaOffset = startOffset;
    }
}

