/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ '\\%SystemDrive\\%\\\\\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001\u0002\u0012$\u0001BB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011!1\u0005A!f\u0001\n\u00039\u0005\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002%\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000bU\u0003A\u0011\t,\t\u000b\u0011\u0004A\u0011I3\t\u000fY\u0004!\u0019!C#o\"9\u0011Q\u0006\u0001!\u0002\u001bA\bbBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\u0007Q\u0001!\t%a\r\t\u000f\u0005U\u0002\u0001\"\u0015\u00028!9\u00111\u000b\u0001\u0005R\u0005U\u0003\"CA0\u0001\u0005\u0005I\u0011AA1\u0011%\tI\u0007AI\u0001\n\u0003\tY\u0007C\u0005\u0002\u0002\u0002\t\n\u0011\"\u0001\u0002l!I\u00111\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"a&\u0001\u0003\u0003%\t!!'\t\u0013\u0005\u0005\u0006!!A\u0005\u0002\u0005\r\u0006\"CAX\u0001\u0005\u0005I\u0011IAY\u0011%\ty\fAA\u0001\n\u0003\t\t\rC\u0005\u0002F\u0002\t\t\u0011\"\u0011\u0002H\u001eI\u0011q_\u0012\u0002\u0002#\u0005\u0011\u0011 \u0004\tE\r\n\t\u0011#\u0001\u0002|\"1A\n\bC\u0001\u0005\u0013A\u0011\"a\f\u001d\u0003\u0003%)Ea\u0003\t\u0013\t5A$!A\u0005\u0002\n=\u0001\"\u0003B\f9\u0005\u0005I\u0011\u0011B\r\u0011%\u0011Y\u0003HA\u0001\n\u0013\u0011iC\u0001\u0003MS.,'B\u0001\u0013&\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0019:\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tTg\u000f\t\u0003eMj\u0011aI\u0005\u0003i\r\u0012Qc\u0015;sS:<'+Z4fq\u0016C\bO]3tg&|g\u000e\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0003\"AM!\n\u0005\t\u001b#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n!\"Z:dCB,7\t[1s+\u0005A\u0005C\u0001\u001cJ\u0013\tQuG\u0001\u0003DQ\u0006\u0014\u0018aC3tG\u0006\u0004Xm\u00115be\u0002\na\u0001P5oSRtD\u0003\u0002(P!F\u0003\"A\r\u0001\t\u000by:\u0001\u0019\u0001!\t\u000b\u0011;\u0001\u0019\u0001!\t\u000b\u0019;\u0001\u0019\u0001%\u0015\u00079\u001bF\u000bC\u0003?\u0011\u0001\u0007\u0001\tC\u0003E\u0011\u0001\u0007\u0001)\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0003/\n\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.8\u001b\u0005Y&B\u0001/0\u0003\u0019a$o\\8u}%\u0011alN\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_o!)1-\u0003a\u0001/\u0006\ta/A\u0004nCR\u001c\u0007.Z:\u0015\u0007\u0019LG\u000f\u0005\u00027O&\u0011\u0001n\u000e\u0002\b\u0005>|G.Z1o\u0011\u0015Q'\u00021\u0001l\u0003\u0015\u0011XmZ3y!\ta'/D\u0001n\u0015\tQgN\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a]7\u0003\u000fA\u000bG\u000f^3s]\")QO\u0003a\u0001/\u0006\u00191\u000f\u001e:\u0002\u00199|G-\u001a)biR,'O\\:\u0016\u0003a\u0004B!\u001f@\u0002\u00049\u0011!\u0010 \b\u00035nL\u0011\u0001O\u0005\u0003{^\nq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u00111aU3r\u0015\tix\u0007\u0005\u0003\u0002\u0006\u0005\u001db\u0002BA\u0004\u0003CqA!!\u0003\u0002\u001e9!\u00111BA\u000e\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002[\u0003'I\u0011AL\u0005\u0003Y5J!AK\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\r\ty\"J\u0001\u0006iJ,Wm]\u0005\u0005\u0003G\t)#A\u0006Ue\u0016,\u0007+\u0019;uKJt'bAA\u0010K%!\u0011\u0011FA\u0016\u0005-!&/Z3QCR$XM\u001d8\u000b\t\u0005\r\u0012QE\u0001\u000e]>$W\rU1ui\u0016\u0014hn\u001d\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012aV\u000b\u0002/\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003s\t)%a\u0014\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010$\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0011\u0002>\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002H=\u0001\r!!\u0013\u0002\u0007\r$\b\u0010\u0005\u0003\u0002<\u0005-\u0013\u0002BA'\u0003{\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002R=\u0001\r!!\u000f\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015q\u0015qKA.\u0011\u0019\tI\u0006\u0005a\u0001\u0001\u00069a.Z<MK\u001a$\bBBA/!\u0001\u0007\u0001)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f9\u000b\u0019'!\u001a\u0002h!9a(\u0005I\u0001\u0002\u0004\u0001\u0005b\u0002#\u0012!\u0003\u0005\r\u0001\u0011\u0005\b\rF\u0001\n\u00111\u0001I\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001c+\u0007\u0001\u000byg\u000b\u0002\u0002rA!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014!C;oG\",7m[3e\u0015\r\tYhN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA@\u0003k\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\b*\u001a\u0001*a\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019\n]\u0001\u0005Y\u0006tw-C\u0002a\u0003#\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a'\u0011\u0007Y\ni*C\u0002\u0002 ^\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!*\u0002,B\u0019a'a*\n\u0007\u0005%vGA\u0002B]fD\u0011\"!,\u0018\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\f\u0005\u0004\u00026\u0006m\u0016QU\u0007\u0003\u0003oS1!!/8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\u000b9L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0002D\"I\u0011QV\r\u0002\u0002\u0003\u0007\u0011QU\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0019\fI\rC\u0005\u0002.j\t\t\u00111\u0001\u0002&\"Z\u0002!!4\u0002T\u0006U\u0017\u0011\\An\u0003?\f\t/!:\u0002h\u0006-\u0018Q^Ay\u0003g\u00042AMAh\u0013\r\t\tn\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9.AA\u000bgR\u0014\be\u0018$V\u001d\u000e{\u0006\u0005]1ui\u0016\u0014hn\u0017\u0011F'\u000e\u000b\u0005+\u0012\u0011fg\u000e\f\u0007/Z/![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007e\u001d;sA5\fGo\u00195fg\u0002\u0002\u0007/\u0019;uKJt\u0007\rI<ji\"\u0004\u0003-Z:dCB,\u0007\r\f\u0011ok2d\u0007%\u001b4!C:L\b%\u0019:hk6,g\u000e^:!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!!8\u0002\u0011KS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=dKB$\u0018n\u001c8!i>\u0004C\u000f[3!M>dGn\\<j]\u001e\u00043\u000f]3dS\u0006d\u0007e]=nE>d7O\u000f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\fI7bi\u000eDWm\u001d\u0011b]f\u0004sN\\3!G\"\f'/Y2uKJ\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!]\u0001Jg\u000e\t9pg&D\bE]3hk2\f'\u000fI3yaJ,7o]5p]NL#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015\u0002S.\u0019;dQ\u0016\u001c\bE_3s_\u0002z'\u000fI7pe\u0016\u00043\r[1sC\u000e$XM]:!S:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011)g&l\u0017\u000e\\1sAQ|\u0007E\f\u0016!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001c\u0018F\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b8!_J$WM\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGn\u001d\u0011cC\u000e\\'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nr#\u0002\t\u0011!A\u0001\u0002#\u0006I3tG\u0006\u0004X\rI\u0017!C:\u00043\r[1sC\u000e$XM\u001d\u0011bI\u0012,G\rI:j]\u000e,\u0007e\u00159be.\u00043G\f\u0019/AQCW\r\t3fM\u0006,H\u000e\u001e\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002J7\u000f\t;iK\u0002:Cl\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011b]\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000f\t9sK\u000e,G-Z:!C\u0002\u001a\b/Z2jC2\u00043/_7c_2\u0004sN\u001d\u0011b]>$\b.\u001a:!KN\u001c\u0017\r]3!G\"\f'/Y2uKJd\u0003\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8mY><\u0018N\\4!G\"\f'/Y2uKJ\u0004\u0013n\u001d\u0011nCR\u001c\u0007.\u001a3!Y&$XM]1mYft\u0003%\u0013;!SN\u0004\u0013N\u001c<bY&$\u0007\u0005^8!KN\u001c\u0017\r]3!C:L\be\u001c;iKJ\u00043\r[1sC\u000e$XM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003G\fA1\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001:s\f]1sW\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012+!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cX\b\u001e:vKnR\u0001\u0005\t\u0011!A\u0001\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0005ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/Vg\u0016\u00148\u000f\u0018&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006e\n/&'f\u001cH/Z7Ee&4X\rX\u0013]9V\u001bXM]:&OmR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E\u000bI:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mgv2\u0017\r\\:fw)\u0001\u0003\u0005\t\u0011!AM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7/\u00034bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/]+N,'o\u001d/]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcF\fX+tKJ\u001cXeJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-J\u0018Vg\u0016\u00148o\f&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006eJ\u0018&'f\u001cH/Z7Ee&4XmL\u00130_U\u001bXM]:&O\u0001*5kQ!Q\u000b\u0002:sfJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003S\fQH\u0003\u0011!A\u0001*6/\u001a\u0011S\u0019&[U\t\t;pA5\fGo\u00195!o&$\b\u000eI:uC:$\u0017M\u001d3!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u000bA\u0001\nQa]5oG\u0016\f#!a<\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005U\u0018a\u00049sK\u0012L7-\u0019;f?\u001a,hnY:\u0002\t1K7.\u001a\t\u0003eq\u0019B\u0001HA\u007fwAA\u0011q B\u0003\u0001\u0002Ce*\u0004\u0002\u0003\u0002)\u0019!1A\u001c\u0002\u000fI,h\u000e^5nK&!!q\u0001B\u0001\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003s$\"!!$\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f9\u0013\tBa\u0005\u0003\u0016!)ah\ba\u0001\u0001\")Ai\ba\u0001\u0001\")ai\ba\u0001\u0011\u00069QO\\1qa2LH\u0003\u0002B\u000e\u0005O\u0001RA\u000eB\u000f\u0005CI1Aa\b8\u0005\u0019y\u0005\u000f^5p]B1aGa\tA\u0001\"K1A!\n8\u0005\u0019!V\u000f\u001d7fg!A!\u0011\u0006\u0011\u0002\u0002\u0003\u0007a*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0006\t\u0005\u0003\u001f\u0013\t$\u0003\u0003\u00034\u0005E%AB(cU\u0016\u001cG\u000f")
public class Like
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;
    private final Seq<Enumeration.Value> nodePatterns;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String toString() {
        String string;
        char c = this.escapeChar();
        switch (c) {
            case '\\': {
                string = new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
                break;
            }
            default: {
                string = new StringBuilder(16).append(this.left()).append(" LIKE ").append(this.right()).append(" ESCAPE '").append(c).append("'").toString();
                break;
            }
        }
        return string;
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.left().sql()).append(" ").append(this.prettyName().toUpperCase(Locale.ROOT)).append(" ").append(this.right().sql()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            String escapedEscapeChar = StringEscapeUtils.escapeJava((String)Character.toString(this.escapeChar()));
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(133).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(\n            ").append(escapeFunc).append("(").append(rightStr).append(", '").append(escapedEscapeChar).append("'));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    @Override
    public Like withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToCharacter((char)this.escapeChar());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.escapeChar() != like.escapeChar()) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.LIKE_FAMLIY(), (List)Nil$.MODULE$);
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

