/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AesEncrypt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, key[, mode[, padding]]) - Returns an encrypted value of `expr` using AES in given `mode` with the specified `padding`.\n      Key lengths of 16, 24 and 32 bits are supported. Supported combinations of (`mode`, `padding`) are ('ECB', 'PKCS') and ('GCM', 'NONE').\n      The default mode is GCM.\n  ", arguments="\n    Arguments:\n      * expr - The binary value to encrypt.\n      * key - The passphrase to use to encrypt the data.\n      * mode - Specifies which block cipher mode should be used to encrypt messages.\n               Valid modes: ECB, GCM.\n      * padding - Specifies how to pad messages whose length is not a multiple of the block size.\n                  Valid values: PKCS, NONE, DEFAULT. The DEFAULT padding means PKCS for ECB and NONE for GCM.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_('Spark', '0000111122223333'));\n       83F16B2AA704794132802D248E6BFD4E380078182D1544813898AC97E709B28A94\n      > SELECT hex(_FUNC_('Spark SQL', '0000111122223333', 'GCM'));\n       6E7CA17BBB468D3084B5744BCA729FB7B2B7BCB8E4472847D02670489D95FA97DBBA7D3210\n      > SELECT base64(_FUNC_('Spark SQL', '1234567890abcdef', 'ECB', 'PKCS'));\n       3lmwu+Mw0H3fi5NDvcu9lg==\n  ", since="3.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0012%\u0001FB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005e!A\u0001\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005J\u0001\tE\t\u0015!\u00033\u0011!Q\u0005A!f\u0001\n\u00031\u0005\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002\u001a\t\u00111\u0003!Q3A\u0005\u0002\u0019C\u0001\"\u0014\u0001\u0003\u0012\u0003\u0006IA\r\u0005\u0006\u001d\u0002!\ta\u0014\u0005\t+\u0002A)\u0019!C!\r\")a\n\u0001C\u0001-\")a\n\u0001C\u00015\")Q\f\u0001C!=\")!\u000e\u0001C!W\")1\u0010\u0001C!y\")a\u0010\u0001C)\u007f\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u00033A\u0011\"a\f\u0001#\u0003%\t!!\u0007\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005e\u0001\"CA\u001a\u0001E\u0005I\u0011AA\r\u0011%\t)\u0004AA\u0001\n\u0003\n9\u0004C\u0005\u0002H\u0001\t\t\u0011\"\u0001\u0002J!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005m\u0004!!A\u0005B\u0005ut!CATI\u0005\u0005\t\u0012AAU\r!\u0019C%!A\t\u0002\u0005-\u0006B\u0002(\u001e\t\u0003\tI\fC\u0005\u0002<v\t\t\u0011\"\u0012\u0002>\"I\u0011qX\u000f\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u0017l\u0012\u0011!CA\u0003\u001bD\u0011\"a8\u001e\u0003\u0003%I!!9\u0003\u0015\u0005+7/\u00128def\u0004HO\u0003\u0002&M\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9\u0003&\u0001\u0005dCR\fG._:u\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\u0002\u0001'\u0019\u0001!GN\u001d=\u0005B\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u001a8\u0013\tADE\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007CA\u001a;\u0013\tYDE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"!P\"\n\u0005\u0011s$\u0001D*fe&\fG.\u001b>bE2,\u0017!B5oaV$X#\u0001\u001a\u0002\r%t\u0007/\u001e;!\u0003\rYW-_\u0001\u0005W\u0016L\b%\u0001\u0003n_\u0012,\u0017!B7pI\u0016\u0004\u0013a\u00029bI\u0012LgnZ\u0001\ta\u0006$G-\u001b8hA\u00051A(\u001b8jiz\"R\u0001U)S'R\u0003\"a\r\u0001\t\u000b\u0015K\u0001\u0019\u0001\u001a\t\u000b!K\u0001\u0019\u0001\u001a\t\u000b)K\u0001\u0019\u0001\u001a\t\u000b1K\u0001\u0019\u0001\u001a\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e\u001e\u000b\u0005!^C\u0016\fC\u0003F\u0017\u0001\u0007!\u0007C\u0003I\u0017\u0001\u0007!\u0007C\u0003K\u0017\u0001\u0007!\u0007F\u0002Q7rCQ!\u0012\u0007A\u0002IBQ\u0001\u0013\u0007A\u0002I\n!\u0002\u001d:fiRLh*Y7f+\u0005y\u0006C\u00011h\u001d\t\tW\r\u0005\u0002c}5\t1M\u0003\u0002ea\u00051AH]8pizJ!A\u001a \u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003Mz\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005a\u0007cA7sk:\u0011a\u000e\u001d\b\u0003E>L\u0011aP\u0005\u0003cz\nq\u0001]1dW\u0006<W-\u0003\u0002ti\n\u00191+Z9\u000b\u0005Et\u0004C\u0001<z\u001b\u00059(B\u0001=)\u0003\u0015!\u0018\u0010]3t\u0013\tQxO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006A1\r[5mIJ,g.F\u0001~!\ri'OM\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2AMA\u0001\u0011\u001d\t\u0019\u0001\u0005a\u0001\u0003\u000b\t1B\\3x\u0007\"LG\u000e\u001a:f]B!Q.a\u00023\u0013\r\tI\u0001\u001e\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$\u0012\u0002UA\b\u0003#\t\u0019\"!\u0006\t\u000f\u0015\u000b\u0002\u0013!a\u0001e!9\u0001*\u0005I\u0001\u0002\u0004\u0011\u0004b\u0002&\u0012!\u0003\u0005\rA\r\u0005\b\u0019F\u0001\n\u00111\u00013\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0007+\u0007I\nib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tICP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\nAA[1wC&\u0019\u0001.!\u0010\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0003cA\u001f\u0002N%\u0019\u0011q\n \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004{\u0005]\u0013bAA-}\t\u0019\u0011I\\=\t\u0013\u0005u\u0003$!AA\u0002\u0005-\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002dA1\u0011QMA6\u0003+j!!a\u001a\u000b\u0007\u0005%d(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001c\u0002h\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019(!\u001f\u0011\u0007u\n)(C\u0002\u0002xy\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002^i\t\t\u00111\u0001\u0002V\u00051Q-];bYN$B!a\u001d\u0002\u0000!I\u0011QL\u000e\u0002\u0002\u0003\u0007\u0011Q\u000b\u0015\u0018\u0001\u0005\r\u0015\u0011RAF\u0003\u001f\u000b\t*!&\u0002\u0018\u0006m\u0015QTAQ\u0003G\u00032aMAC\u0013\r\t9\t\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti)\u0001B9\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003e[3z72\u0002Sn\u001c3f72\u0002\u0003/\u00193eS:<W,X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013M\u001c\u0011f]\u000e\u0014\u0018\u0010\u001d;fI\u00022\u0018\r\\;fA=4\u0007\u0005Y3yaJ\u0004\u0007%^:j]\u001e\u0004\u0013)R*!S:\u0004s-\u001b<f]\u0002\u0002Wn\u001c3fA\u0002:\u0018\u000e\u001e5!i\",\u0007e\u001d9fG&4\u0017.\u001a3!AB\fG\rZ5oO\u0002t#\u0002\t\u0011!A\u0001\u00023*Z=!Y\u0016tw\r\u001e5tA=4\u0007%\r\u001c-AI\"\u0004%\u00198eAM\u0012\u0004EY5ug\u0002\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u00023+\u001e9q_J$X\r\u001a\u0011d_6\u0014\u0017N\\1uS>t7\u000fI8gA!\u0002Wn\u001c3fA2\u0002\u0003\r]1eI&tw\rY\u0015!CJ,\u0007\u0005K\u0014F\u0007\n;C\u0006I\u0014Q\u0017\u000e\u001bv%\u000b\u0011b]\u0012\u0004\u0003fJ$D\u001b\u001eb\u0003e\n(P\u001d\u0016;\u0013F\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u0002\"WMZ1vYR\u0004Sn\u001c3fA%\u001c\beR\"N])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u00111S\u0001\u0004\u0006*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qe\u0002j\u0003\u0005\u00165fA\tLg.\u0019:zAY\fG.^3!i>\u0004SM\\2ssB$hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011lKf\u0004S\u0006\t+iK\u0002\u0002\u0018m]:qQJ\f7/\u001a\u0011u_\u0002*8/\u001a\u0011u_\u0002*gn\u0019:zaR\u0004C\u000f[3!I\u0006$\u0018M\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>$W\rI\u0017!'B,7-\u001b4jKN\u0004s\u000f[5dQ\u0002\u0012Gn\\2lA\rL\u0007\u000f[3sA5|G-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*8/\u001a3!i>\u0004SM\\2ssB$\b%\\3tg\u0006<Wm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AY\u000bG.\u001b3![>$Wm\u001d\u001e!\u000b\u000e\u0013E\u0006I$D\u001b:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1eI&tw\rI\u0017!'B,7-\u001b4jKN\u0004\u0003n\\<!i>\u0004\u0003/\u00193![\u0016\u001c8/Y4fg\u0002:\bn\\:fA1,gn\u001a;iA%\u001c\bE\\8uA\u0005\u0004S.\u001e7uSBdW\rI8gAQDW\r\t2m_\u000e\\\u0007e]5{K:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!-\u0006d\u0017\u000e\u001a\u0011wC2,Xm\u001d\u001e!!.\u001b5\u000b\f\u0011O\u001f:+E\u0006\t#F\r\u0006+F\n\u0016\u0018!)\",\u0007\u0005R#G\u0003VcE\u000b\t9bI\u0012Lgn\u001a\u0011nK\u0006t7\u000f\t)L\u0007N\u0003cm\u001c:!\u000b\u000e\u0013\u0005%\u00198eA9{e*\u0012\u0011g_J\u0004siQ'/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0015aa\r\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA!,\u0007\u0010K0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!OA\u0002\u0004\u0007M\u00192cE\u0012$G\r\u001a4gM\u001at%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Aa\u001ad)\r\u001cCe\u0005\u000bu\u0007\r\u001b8sQ\n4G\r\u001d1e\u0011\u0013D\u0007O#7\u0005\u001a#E'R\u001a9aA:\u0004(\r\u001d3\tF*D\u0007\u000e\u001d2gaJ\u0004(Q\":o\u0015;\u0004'\u000f\"3q\u0005KDG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iKbDsLR+O\u0007~Cse\u00159be.\u00043+\u0015'(Y\u0001:\u0003\u0007\r\u00191cE\n\u0014G\r\u001a3eM\u001a4gM\u0014-A\u001d:5)T\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002c'R\u001cD\u0003F:$I\u0011\"5ma\"5\u0007\r\u001d5\u0005V:D\u0007\u000e\"D\u0003^\u0012\u0014H\u0012\"8\u0005J\u0012uGQ\"Cq\u0015#Dg\u000e\u001a9i]\"\u0005G\r\u001c8aQB\u0014\bR\u001d6\r\u0006Kt\u0007\u0012\"C\u0003^\"5GM\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0017m]37i!zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-A\u001d\n$g\r\u001b6m]B\u0014\bM1cG\u0012,gm\n\u0017!O\u0015\u001b%i\n\u0017!OA[5iU\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007\\7xk.ju\u000f\r%4M&,d\n\u0012<dkfbw-P\u001f\u000bA\u0001\nQa]5oG\u0016\f#!a(\u0002\u000bMr3G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0015\u0016AC7jg\u000e|f-\u001e8dg\u0006Q\u0011)Z:F]\u000e\u0014\u0018\u0010\u001d;\u0011\u0005Mj2\u0003B\u000f\u0002.\n\u0003\u0012\"a,\u00026J\u0012$G\r)\u000e\u0005\u0005E&bAAZ}\u00059!/\u001e8uS6,\u0017\u0002BA\\\u0003c\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\tI+\u0001\u0005u_N#(/\u001b8h)\t\tI$A\u0003baBd\u0017\u0010F\u0005Q\u0003\u0007\f)-a2\u0002J\")Q\t\ta\u0001e!)\u0001\n\ta\u0001e!)!\n\ta\u0001e!)A\n\ta\u0001e\u00059QO\\1qa2LH\u0003BAh\u00037\u0004R!PAi\u0003+L1!a5?\u0005\u0019y\u0005\u000f^5p]B9Q(a63eI\u0012\u0014bAAm}\t1A+\u001e9mKRB\u0001\"!8\"\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a9\u0011\t\u0005m\u0012Q]\u0005\u0005\u0003O\fiD\u0001\u0004PE*,7\r\u001e")
public class AesEncrypt
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Expression key;
    private final Expression mode;
    private final Expression padding;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression preCanonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(AesEncrypt aesEncrypt) {
        return AesEncrypt$.MODULE$.unapply(aesEncrypt);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, AesEncrypt> tupled() {
        return AesEncrypt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, AesEncrypt>>>> curried() {
        return AesEncrypt$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression preCanonicalized$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.preCanonicalized = RuntimeReplaceable.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression key() {
        return this.key;
    }

    public Expression mode() {
        return this.mode;
    }

    public Expression padding() {
        return this.padding;
    }

    private Expression replacement$lzycompute() {
        AesEncrypt aesEncrypt = this;
        synchronized (aesEncrypt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, BinaryType$.MODULE$, "aesEncrypt", (Seq<Expression>)((Seq)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)Nil$.MODULE$))))), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "aes_encrypt";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)Nil$.MODULE$))));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3));
    }

    public AesEncrypt copy(Expression input, Expression key, Expression mode, Expression padding) {
        return new AesEncrypt(input, key, mode, padding);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.key();
    }

    public Expression copy$default$3() {
        return this.mode();
    }

    public Expression copy$default$4() {
        return this.padding();
    }

    @Override
    public String productPrefix() {
        return "AesEncrypt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.input();
                break;
            }
            case 1: {
                expression = this.key();
                break;
            }
            case 2: {
                expression = this.mode();
                break;
            }
            case 3: {
                expression = this.padding();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AesEncrypt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AesEncrypt)) return false;
        boolean bl = true;
        if (!bl) return false;
        AesEncrypt aesEncrypt = (AesEncrypt)x$1;
        Expression expression = this.input();
        Expression expression2 = aesEncrypt.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.key();
        Expression expression4 = aesEncrypt.key();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mode();
        Expression expression6 = aesEncrypt.mode();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.padding();
        Expression expression8 = aesEncrypt.padding();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!aesEncrypt.canEqual(this)) return false;
        return true;
    }

    public AesEncrypt(Expression input, Expression key, Expression mode, Expression padding) {
        this.input = input;
        this.key = key;
        this.mode = mode;
        this.padding = padding;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public AesEncrypt(Expression input, Expression key, Expression mode) {
        this(input, key, mode, Literal$.MODULE$.apply("DEFAULT"));
    }

    public AesEncrypt(Expression input, Expression key) {
        this(input, key, Literal$.MODULE$.apply("GCM"));
    }
}

