/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001b\tiA)\u0019;b)f\u0004XmU;ji\u0016T!a\u0001\u0003\u0002\u000bQL\b/Z:\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\u0016G\",7m\u001b#bi\u0006$\u0016\u0010]3Ge>l'j]8o)\tQ\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0003V]&$\b\"B\u0011\u0018\u0001\u0004\u0011\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005Y\u0019\u0013B\u0001\u0013\u0003\u0005!!\u0015\r^1UsB,\u0007\"\u0002\u0014\u0001\t\u00039\u0013\u0001F2iK\u000e\\G)\u0019;b)f\u0004XM\u0012:p[\u0012#E\n\u0006\u0002\u001bQ!)\u0011%\na\u0001E!9!\u0006\u0001b\u0001\n\u0003Y\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u00031\u0002\"AF\u0017\n\u00059\u0012!\u0001C'fi\u0006$\u0017\r^1\t\rA\u0002\u0001\u0015!\u0003-\u0003%iW\r^1eCR\f\u0007\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\u0002\u0015M$(/^2u)f\u0004X-F\u00015!\t1R'\u0003\u00027\u0005\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\ra\u0002\u0001\u0015!\u00035\u0003-\u0019HO];diRK\b/\u001a\u0011\t\u000bi\u0002A\u0011A\u001e\u0002!\rDWmY6EK\u001a\fW\u000f\u001c;TSj,Gc\u0001\u000e={!)\u0011%\u000fa\u0001E!)a(\u000fa\u0001\u007f\u0005\u0019R\r\u001f9fGR,G\rR3gCVdGoU5{KB\u00111\u0004Q\u0005\u0003\u0003r\u00111!\u00138u\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003\u0019\u001a\u0007.Z2l\u000bF,\u0018\r\\:JO:|'/Z\"p[B\fG/\u001b2mK:+H\u000e\\1cS2LG/\u001f\u000b\u00055\u0015;\u0015\nC\u0003G\u0005\u0002\u0007!%\u0001\u0003ge>l\u0007\"\u0002%C\u0001\u0004\u0011\u0013A\u0001;p\u0011\u0015Q%\t1\u0001L\u0003!)\u0007\u0010]3di\u0016$\u0007CA\u000eM\u0013\tiEDA\u0004C_>dW-\u00198\t\u000b=\u0003A\u0011\u0001)\u0002%\rDWmY6DCR\fGn\\4TiJLgn\u001a\u000b\u00035ECQA\u0015(A\u0002\t\n!\u0001\u001a;\t\u000bQ\u0003A\u0011A+\u0002\u0019\r\u0014X-\u0019;f'R\u0014Xo\u0019;\u0015\u0005Q2\u0006\"B,T\u0001\u0004y\u0014!\u00018\t\u000be\u0003A\u0011\u0001.\u0002/\rDWmY6FcV\fGn]*ueV\u001cG/\u001e:bY2LH\u0003\u0002\u000e\\9vCQA\u0012-A\u0002\tBQ\u0001\u0013-A\u0002\tBQA\u0013-A\u0002-\u0003")
public class DataTypeSuite
extends SparkFunSuite {
    private final Metadata metadata;
    private final StructType structType;

    public void checkDataTypeFromJson(DataType dataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from Json - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dataType$1;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DataType$.MODULE$.fromJson(this.dataType$1.json()));
                DataType $org_scalatest_assert_macro_right = this.dataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataType$1 = dataType$1;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }

    public void checkDataTypeFromDDL(DataType dataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from DDL - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dataType$2;

            public final Assertion apply() {
                StructType parsed = StructType$.MODULE$.fromDDL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataType$2.sql()})));
                StructType expected = new StructType().add("a", this.dataType$2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(parsed.sameType((DataType)expected), "parsed.sameType(expected)", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataType$2 = dataType$2;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public StructType structType() {
        return this.structType;
    }

    public void checkDefaultSize(DataType dataType, int expectedDefaultSize) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check the default size of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataType, expectedDefaultSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dataType$3;
            private final int expectedDefaultSize$1;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.dataType$3.defaultSize()));
                int $org_scalatest_assert_macro_right = this.expectedDefaultSize$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataType$3 = dataType$3;
                this.expectedDefaultSize$1 = expectedDefaultSize$1;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
    }

    public void checkEqualsIgnoreCompatibleNullability(DataType from, DataType to, boolean expected) {
        String testName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"equalsIgnoreCompatibleNullability: (from: ", ", to: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to}));
        this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, from, to, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType from$1;
            private final DataType to$1;
            private final boolean expected$1;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleNullability(this.from$1, this.to$1)));
                boolean $org_scalatest_assert_macro_right = this.expected$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.from$1 = from$1;
                this.to$1 = to$1;
                this.expected$1 = expected$1;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
    }

    public void checkCatalogString(DataType dt) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalogString: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dt$1;

            public final Assertion apply() {
                DataType dt2 = CatalystSqlParser$.MODULE$.parseDataType(this.dt$1.catalogString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.dt$1);
                DataType $org_scalatest_assert_macro_right = dt2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dt$1 = dt$1;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
    }

    public StructType createStruct(int n) {
        return new StructType((StructField[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(int i) {
                return new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            }
        }, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public void checkEqualsStructurally(DataType from, DataType to, boolean expected) {
        String testName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"equalsStructurally: (from: ", ", to: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to}));
        this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, from, to, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType from$2;
            private final DataType to$2;
            private final boolean expected$2;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurally(this.from$2, this.to$2, DataType$.MODULE$.equalsStructurally$default$3())));
                boolean $org_scalatest_assert_macro_right = this.expected$2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.from$2 = from$2;
                this.to$2 = to$2;
                this.expected$2 = expected$2;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
    }

    public DataTypeSuite() {
        this.test("construct an ArrayType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                ArrayType array = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new ArrayType((DataType)StringType$.MODULE$, true));
                ArrayType $org_scalatest_assert_macro_right = array;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("construct an MapType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                MapType map = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true));
                MapType $org_scalatest_assert_macro_right = map;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("construct with add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$, true).add("b", (DataType)LongType$.MODULE$, false).add("c", (DataType)StringType$.MODULE$, true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("construct with add from StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructType struct = new StructType().add(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("construct with add from StructField with comments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructType struct = new StructType().add("a", "int", true, "test1").add("b", (DataType)StringType$.MODULE$, true, "test3").add(new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4")).add(new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_left = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test1");
                StructField $org_scalatest_assert_macro_right = struct.apply("a");
                StructField structField = $org_scalatest_assert_macro_left;
                StructField structField2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structField != null ? !structField.equals(structField2) : structField2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                StructField $org_scalatest_assert_macro_left2 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test3");
                StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
                StructField structField3 = $org_scalatest_assert_macro_left2;
                StructField structField4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structField3 != null ? !structField3.equals(structField4) : structField4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                StructField $org_scalatest_assert_macro_left3 = new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4");
                StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
                StructField structField5 = $org_scalatest_assert_macro_left3;
                StructField structField6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structField5 != null ? !structField5.equals(structField6) : structField6 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                StructField $org_scalatest_assert_macro_left4 = new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField $org_scalatest_assert_macro_right4 = struct.apply("d");
                StructField structField7 = $org_scalatest_assert_macro_left4;
                StructField structField8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structField7 != null ? !structField7.equals(structField8) : structField8 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                Option $org_scalatest_assert_macro_left5 = struct.apply("c").getComment();
                Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)"test4");
                Option option = $org_scalatest_assert_macro_left5;
                Option option2 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
                Option $org_scalatest_assert_macro_left6 = struct.apply("d").getComment();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("construct with String DataType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructType struct = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("a");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("extract fields from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final IllegalArgumentException apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructField structField3 = new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructField structField4 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$1;

                    public final StructField apply() {
                        return this.struct$1.apply("e");
                    }
                    {
                        this.struct$1 = struct$1;
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                StructField structField5 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructField structField6 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructType expectedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(expectedStruct);
                StructType $org_scalatest_assert_macro_right2 = struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d"})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$1;

                    public final StructType apply() {
                        return this.struct$1.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d", "e", "f"})));
                    }
                    {
                        this.struct$1 = struct$1;
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("extract field index from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final IllegalArgumentException apply() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("a")));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("b")));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$2;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.struct$2.fieldIndex("non_existent");
                    }
                    {
                        this.struct$2 = struct$2;
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("fieldsMap returns map of name to StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                Map mapped = StructType$.MODULE$.fieldsMap(struct.fields());
                Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(mapped);
                Map $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("merge where right contains type conflict", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                StructField structField3 = new StructField("b", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3));
                String message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this, left, right){
                    public static final long serialVersionUID = 0L;
                    private final StructType left$1;
                    private final StructType right$1;

                    public final StructType apply() {
                        return this.left$1.merge(this.right$1);
                    }
                    {
                        this.left$1 = left$1;
                        this.right$1 = right$1;
                    }
                }, ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145))).getMessage();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(message.equals("Failed to merge fields 'b' and 'b'. Failed to merge incompatible data types FloatType and LongType"), "message.equals(\"Failed to merge fields \\'b\\' and \\'b\\'. Failed to merge incompatible data types FloatType and LongType\")", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("existsRecursively", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$16) {
                        return x$16 instanceof LongType;
                    }
                }), "struct.existsRecursively(((x$16: org.apache.spark.sql.types.DataType) => x$16.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$17) {
                        return x$17 instanceof StructType;
                    }
                }), "struct.existsRecursively(((x$17: org.apache.spark.sql.types.DataType) => x$17.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$18) {
                        return x$18 instanceof IntegerType;
                    }
                }), "struct.existsRecursively(((x$18: org.apache.spark.sql.types.DataType) => x$18.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                MapType mapType = MapType$.MODULE$.apply((DataType)struct, (DataType)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$19) {
                        return x$19 instanceof LongType;
                    }
                }), "mapType.existsRecursively(((x$19: org.apache.spark.sql.types.DataType) => x$19.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$20) {
                        return x$20 instanceof StructType;
                    }
                }), "mapType.existsRecursively(((x$20: org.apache.spark.sql.types.DataType) => x$20.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$21) {
                        return x$21 instanceof StringType;
                    }
                }), "mapType.existsRecursively(((x$21: org.apache.spark.sql.types.DataType) => x$21.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$22) {
                        return x$22 instanceof MapType;
                    }
                }), "mapType.existsRecursively(((x$22: org.apache.spark.sql.types.DataType) => x$22.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$23) {
                        return x$23 instanceof IntegerType;
                    }
                }), "mapType.existsRecursively(((x$23: org.apache.spark.sql.types.DataType) => x$23.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)mapType);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$24) {
                        return x$24 instanceof LongType;
                    }
                }), "arrayType.existsRecursively(((x$24: org.apache.spark.sql.types.DataType) => x$24.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$25) {
                        return x$25 instanceof StructType;
                    }
                }), "arrayType.existsRecursively(((x$25: org.apache.spark.sql.types.DataType) => x$25.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$26) {
                        return x$26 instanceof StringType;
                    }
                }), "arrayType.existsRecursively(((x$26: org.apache.spark.sql.types.DataType) => x$26.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$27) {
                        return x$27 instanceof MapType;
                    }
                }), "arrayType.existsRecursively(((x$27: org.apache.spark.sql.types.DataType) => x$27.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$28) {
                        return x$28 instanceof ArrayType;
                    }
                }), "arrayType.existsRecursively(((x$28: org.apache.spark.sql.types.DataType) => x$28.isInstanceOf[org.apache.spark.sql.types.ArrayType]))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$29) {
                        return x$29 instanceof IntegerType;
                    }
                }), "arrayType.existsRecursively(((x$29: org.apache.spark.sql.types.DataType) => x$29.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.checkDataTypeFromJson((DataType)NullType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromJson((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromJson((DataType)LongType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)LongType$.MODULE$);
        this.checkDataTypeFromJson((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromJson((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromDDL((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromJson((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromDDL((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromJson((DataType)DateType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DateType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromJson((DataType)StringType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)StringType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.metadata = new MetadataBuilder().putString("name", "age").build();
        this.structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)DoubleType$.MODULE$, false, this.metadata())})));
        this.checkDataTypeFromJson((DataType)this.structType());
        this.checkDataTypeFromDDL((DataType)this.structType());
        this.test("fromJson throws an exception when given type string is invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final Assertion apply() {
                String message;
                String $org_scalatest_assert_macro_left = message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply() {
                        return DataType$.MODULE$.fromJson("\"abcd\"");
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254))).getMessage();
                String $org_scalatest_assert_macro_right = "Failed to convert the JSON string 'abcd' to a data type.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
                String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply() {
                        return DataType$.MODULE$.fromJson("{\"abcd\":\"a\"}");
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260))).getMessage();
                String $org_scalatest_assert_macro_right2 = "Failed to convert the JSON string '{\"abcd\":\"a\"}' to a data type";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
                String $org_scalatest_assert_macro_left3 = message = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply() {
                        return DataType$.MODULE$.fromJson("{\"fields\": [{\"a\":123}], \"type\": \"struct\"}");
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266))).getMessage();
                String $org_scalatest_assert_macro_right3 = "Failed to convert the JSON string '{\"a\":123}' to a field.";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
                String $org_scalatest_assert_macro_left4 = message = ((JsonProcessingException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply() {
                        return DataType$.MODULE$.fromJson("abcd");
                    }
                }, ClassTag$.MODULE$.apply(JsonParseException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273))).getMessage();
                String $org_scalatest_assert_macro_right4 = "Unrecognized token 'abcd'";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.checkDefaultSize((DataType)NullType$.MODULE$, 1);
        this.checkDefaultSize((DataType)BooleanType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ByteType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ShortType$.MODULE$, 2);
        this.checkDefaultSize((DataType)IntegerType$.MODULE$, 4);
        this.checkDefaultSize((DataType)LongType$.MODULE$, 8);
        this.checkDefaultSize((DataType)FloatType$.MODULE$, 4);
        this.checkDefaultSize((DataType)DoubleType$.MODULE$, 8);
        this.checkDefaultSize((DataType)new DecimalType(10, 5), 8);
        this.checkDefaultSize((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), 16);
        this.checkDefaultSize((DataType)DateType$.MODULE$, 4);
        this.checkDefaultSize((DataType)TimestampType$.MODULE$, 8);
        this.checkDefaultSize((DataType)StringType$.MODULE$, 20);
        this.checkDefaultSize((DataType)BinaryType$.MODULE$, 100);
        this.checkDefaultSize((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), 8);
        this.checkDefaultSize((DataType)new ArrayType((DataType)StringType$.MODULE$, false), 20);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), 24);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false), 12);
        this.checkDefaultSize((DataType)this.structType(), 20);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true);
        StructField structField3 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4)), true);
        StructField structField5 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6)), true);
        StructField structField7 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8)), false);
        StructField structField9 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10).$colon$colon((Object)structField9)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11)), false);
        this.checkCatalogString((DataType)BooleanType$.MODULE$);
        this.checkCatalogString((DataType)ByteType$.MODULE$);
        this.checkCatalogString((DataType)ShortType$.MODULE$);
        this.checkCatalogString((DataType)IntegerType$.MODULE$);
        this.checkCatalogString((DataType)LongType$.MODULE$);
        this.checkCatalogString((DataType)FloatType$.MODULE$);
        this.checkCatalogString((DataType)DoubleType$.MODULE$);
        this.checkCatalogString((DataType)new DecimalType(10, 5));
        this.checkCatalogString((DataType)BinaryType$.MODULE$);
        this.checkCatalogString((DataType)StringType$.MODULE$);
        this.checkCatalogString((DataType)DateType$.MODULE$);
        this.checkCatalogString((DataType)TimestampType$.MODULE$);
        this.checkCatalogString((DataType)this.createStruct(4));
        this.checkCatalogString((DataType)this.createStruct(40));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)this.createStruct(40)));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)this.createStruct(40)));
        this.checkEqualsStructurally((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true);
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$), true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false), false);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false);
    }
}

