/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprId$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.PlanTestBase$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

public abstract class PlanTestBase$class {
    public static SQLConf conf(PlanTestBase $this) {
        return SQLConf$.MODULE$.get();
    }

    public static LogicalPlan normalizeExprIds(PlanTestBase $this, LogicalPlan plan) {
        return (LogicalPlan)plan.transformAllExpressions((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ScalarSubquery) {
                    ScalarSubquery scalarSubquery = (ScalarSubquery)A1;
                    ExprId x$6 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$7 = scalarSubquery.copy$default$1();
                    Seq x$8 = scalarSubquery.copy$default$2();
                    object = scalarSubquery.copy(x$7, x$8, x$6);
                } else if (A1 instanceof Exists) {
                    Exists exists = (Exists)A1;
                    ExprId x$9 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$10 = exists.copy$default$1();
                    Seq x$11 = exists.copy$default$2();
                    object = exists.copy(x$10, x$11, x$9);
                } else if (A1 instanceof ListQuery) {
                    ListQuery listQuery = (ListQuery)A1;
                    ExprId x$12 = ExprId$.MODULE$.apply(0L);
                    LogicalPlan x$13 = listQuery.copy$default$1();
                    Seq x$14 = listQuery.copy$default$2();
                    Seq x$15 = listQuery.copy$default$4();
                    object = listQuery.copy(x$13, x$14, x$12, x$15);
                } else if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    String x$16 = attributeReference.name();
                    DataType x$17 = attributeReference.dataType();
                    boolean x$18 = attributeReference.nullable();
                    Metadata x$19 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$20 = ExprId$.MODULE$.apply(0L);
                    Option x$21 = AttributeReference$.MODULE$.apply$default$6(x$16, x$17, x$18, x$19);
                    object = new AttributeReference(x$16, x$17, x$18, x$19, x$20, x$21);
                } else if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    Expression x$22 = alias.child();
                    String x$23 = alias.name();
                    ExprId x$24 = ExprId$.MODULE$.apply(0L);
                    Option x$25 = Alias$.MODULE$.apply$default$4(x$22, x$23);
                    Option x$26 = Alias$.MODULE$.apply$default$5(x$22, x$23);
                    object = new Alias(x$22, x$23, x$24, x$25, x$26);
                } else if (A1 instanceof AggregateExpression) {
                    AggregateExpression aggregateExpression = (AggregateExpression)A1;
                    ExprId x$27 = ExprId$.MODULE$.apply(0L);
                    AggregateFunction x$28 = aggregateExpression.copy$default$1();
                    AggregateMode x$29 = aggregateExpression.copy$default$2();
                    boolean x$30 = aggregateExpression.copy$default$3();
                    object = aggregateExpression.copy(x$28, x$29, x$30, x$27);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof ScalarSubquery ? true : (expression instanceof Exists ? true : (expression instanceof ListQuery ? true : (expression instanceof AttributeReference ? true : (expression instanceof Alias ? true : expression instanceof AggregateExpression))));
                return bl;
            }
        });
    }

    public static LogicalPlan normalizePlan(PlanTestBase $this, LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanTestBase $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Filter) {
                    Filter filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null) {
                        Expression expression = condition;
                        if (child != null) {
                            LogicalPlan logicalPlan = child;
                            object = new Filter((Expression)((TraversableOnce)((SeqLike)this.$outer.splitConjunctivePredicates(expression).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PlanTestBase$.anonfun.normalizePlan.1 $outer;

                                public final Expression apply(Expression condition) {
                                    return PlanTestBase$class.org$apache$spark$sql$catalyst$plans$PlanTestBase$$rewriteEqual(this.$outer.org$apache$spark$sql$catalyst$plans$PlanTestBase$$anonfun$$$outer(), condition);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Expression x$1) {
                                    return x$1.hashCode();
                                }
                            }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)And$.MODULE$), logicalPlan);
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof Sample) {
                    Sample sample = (Sample)A1;
                    long x$31 = 0L;
                    double x$32 = sample.copy$default$1();
                    double x$33 = sample.copy$default$2();
                    boolean x$34 = sample.copy$default$3();
                    LogicalPlan x$35 = sample.copy$default$5();
                    object = sample.copy(x$32, x$33, x$34, x$31, x$35);
                    return (B1)object;
                }
                if (A1 instanceof Join) {
                    Join join = (Join)A1;
                    LogicalPlan left = join.left();
                    LogicalPlan right = join.right();
                    JoinType joinType = join.joinType();
                    Option condition = join.condition();
                    if (condition.isDefined()) {
                        Expression newCondition = (Expression)((TraversableOnce)((SeqLike)this.$outer.splitConjunctivePredicates((Expression)condition.get()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PlanTestBase$.anonfun.normalizePlan.1 $outer;

                            public final Expression apply(Expression condition) {
                                return PlanTestBase$class.org$apache$spark$sql$catalyst$plans$PlanTestBase$$rewriteEqual(this.$outer.org$apache$spark$sql$catalyst$plans$PlanTestBase$$anonfun$$$outer(), condition);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Expression x$2) {
                                return x$2.hashCode();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)And$.MODULE$);
                        object = new Join(left, right, joinType, (Option)new Some((Object)newCondition));
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan = x2;
                if (logicalPlan instanceof Filter) {
                    Filter filter = (Filter)logicalPlan;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null && child != null) {
                        return true;
                    }
                }
                if (logicalPlan instanceof Sample) {
                    return true;
                }
                if (!(logicalPlan instanceof Join)) return false;
                Join join = (Join)logicalPlan;
                Option condition = join.condition();
                if (!condition.isDefined()) return false;
                return true;
            }

            public /* synthetic */ PlanTestBase org$apache$spark$sql$catalyst$plans$PlanTestBase$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expression org$apache$spark$sql$catalyst$plans$PlanTestBase$$rewriteEqual(PlanTestBase $this, Expression condition) {
        Expression expression = condition;
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression l = equalTo.left();
            Expression r = equalTo.right();
            if (l != null) {
                Expression expression2 = l;
                if (r != null) {
                    Expression expression3 = r;
                    return (Expression)((TraversableOnce)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression2, expression3}))).sortBy((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Expression x$3) {
                            return x$3.hashCode();
                        }
                    }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)EqualTo$.MODULE$);
                }
            }
        }
        if (!(expression instanceof EqualNullSafe)) return condition;
        EqualNullSafe equalNullSafe = (EqualNullSafe)expression;
        Expression l = equalNullSafe.left();
        Expression r = equalNullSafe.right();
        if (l == null) return condition;
        Expression expression4 = l;
        if (r == null) return condition;
        Expression expression5 = r;
        return (Expression)((TraversableOnce)((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression4, expression5}))).sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Expression x$4) {
                return x$4.hashCode();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)EqualNullSafe$.MODULE$);
    }

    public static void comparePlans(PlanTestBase $this, LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        if (checkAnalysis) {
            SimpleAnalyzer$.MODULE$.checkAnalysis(plan1);
            SimpleAnalyzer$.MODULE$.checkAnalysis(plan2);
        }
        LogicalPlan normalized1 = $this.normalizePlan($this.normalizeExprIds(plan1));
        LogicalPlan normalized2 = $this.normalizePlan($this.normalizeExprIds(plan2));
        LogicalPlan logicalPlan = normalized1;
        LogicalPlan logicalPlan2 = normalized2;
        if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
            return;
        }
        throw ((Assertions)$this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |== FAIL: Plans do not match ===\n          |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(normalized1.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin(), new Position("PlanTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }

    public static boolean comparePlans$default$3(PlanTestBase $this) {
        return true;
    }

    public static void compareExpressions(PlanTestBase $this, Expression e1, Expression e2) {
        $this.comparePlans((LogicalPlan)new Filter(e1, (LogicalPlan)new OneRowRelation()), (LogicalPlan)new Filter(e2, (LogicalPlan)new OneRowRelation()), false);
    }

    public static void compareJoinOrder(PlanTestBase $this, LogicalPlan plan1, LogicalPlan plan2) {
        LogicalPlan normalized2;
        LogicalPlan normalized1 = $this.normalizePlan($this.normalizeExprIds(plan1));
        if (PlanTestBase$class.sameJoinPlan($this, normalized1, normalized2 = $this.normalizePlan($this.normalizeExprIds(plan2)))) {
            return;
        }
        throw ((Assertions)$this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |== FAIL: Plans do not match ===\n           |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(normalized1.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin(), new Position("PlanTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }

    private static boolean sameJoinPlan(PlanTestBase $this, LogicalPlan plan1, LogicalPlan plan2) {
        boolean bl;
        block7: {
            block8: {
                while (true) {
                    Tuple2 tuple2;
                    if ((tuple2 = new Tuple2((Object)plan1, (Object)plan2)) != null) {
                        LogicalPlan j1 = (LogicalPlan)tuple2._1();
                        LogicalPlan j2 = (LogicalPlan)tuple2._2();
                        if (j1 instanceof Join) {
                            Join join = (Join)j1;
                            if (j2 instanceof Join) {
                                boolean bl2;
                                Join join2 = (Join)j2;
                                if (PlanTestBase$class.sameJoinPlan($this, join.left(), join2.left()) && PlanTestBase$class.sameJoinPlan($this, join.right(), join2.right())) {
                                    bl2 = true;
                                } else {
                                    if (PlanTestBase$class.sameJoinPlan($this, join.left(), join2.right())) {
                                        plan2 = join2.left();
                                        plan1 = join.right();
                                        continue;
                                    }
                                    bl2 = false;
                                }
                                bl = bl2;
                                break block7;
                            }
                        }
                    }
                    if (tuple2 == null) break block8;
                    LogicalPlan p1 = (LogicalPlan)tuple2._1();
                    LogicalPlan p2 = (LogicalPlan)tuple2._2();
                    if (!(p1 instanceof Project)) break block8;
                    Project project = (Project)p1;
                    if (!(p2 instanceof Project)) break block8;
                    Project project2 = (Project)p2;
                    Seq seq = project.projectList();
                    Seq seq2 = project2.projectList();
                    if (seq != null ? !seq.equals(seq2) : seq2 != null) break;
                    plan2 = project2.child();
                    plan1 = project.child();
                }
                bl = false;
                break block7;
            }
            LogicalPlan logicalPlan = plan1;
            LogicalPlan logicalPlan2 = plan2;
            bl = !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withSQLConf(PlanTestBase $this, Seq pairs, Function0 f2) {
        Tuple2 tuple22;
        SQLConf conf = SQLConf$.MODULE$.get();
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys, (Object)values);
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final SQLConf conf$1;

            public final Option<String> apply(String key) {
                return this.conf$1.contains(key) ? new Some((Object)this.conf$1.getConfString(key)) : None$.MODULE$;
            }
            {
                this.conf$1 = conf$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final SQLConf conf$1;

            public final void apply(String k, String v) {
                if (SQLConf$.MODULE$.staticConfKeys().contains(k)) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot modify the value of a static config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                this.conf$1.setConfString(k, v);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        try {
            f2.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            void var3_3;
            void var11_11;
            void var9_9;
            ((IterableLike)var9_9.zip((GenIterable)var11_11, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, (SQLConf)var3_3){
                public static final long serialVersionUID = 0L;
                private final SQLConf conf$1;

                public final void apply(Tuple2<String, Option<String>> x0$1) {
                    Tuple2<String, Option<String>> tuple2;
                    block4: {
                        block3: {
                            block2: {
                                tuple2 = x0$1;
                                if (tuple2 == null) break block2;
                                String key = (String)tuple2._1();
                                Option option = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String value = (String)some.x();
                                this.conf$1.setConfString(key, value);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            Option option = (Option)tuple2._2();
                            if (!None$.MODULE$.equals(option)) break block4;
                            this.conf$1.unsetConf(key);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            throw throwable;
        }
        ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void $init$(PlanTestBase $this) {
    }
}

