/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.apache.zookeeper.client.ConnectStringParser;

public class SolrClientFactory {
    private PrometheusExporterSettings settings;

    public SolrClientFactory(PrometheusExporterSettings settings) {
        this.settings = settings;
    }

    public HttpSolrClient createStandaloneSolrClient(String solrHost) {
        NoOpResponseParser responseParser = new NoOpResponseParser();
        responseParser.setWriterType("json");
        HttpSolrClient.Builder standaloneBuilder = new HttpSolrClient.Builder();
        standaloneBuilder.withBaseSolrUrl(solrHost);
        ((HttpSolrClient.Builder)standaloneBuilder.withConnectionTimeout(this.settings.getHttpConnectionTimeout())).withSocketTimeout(this.settings.getHttpReadTimeout());
        HttpSolrClient httpSolrClient = standaloneBuilder.build();
        httpSolrClient.setParser((ResponseParser)responseParser);
        return httpSolrClient;
    }

    public CloudSolrClient createCloudSolrClient(String zookeeperConnectionString) {
        NoOpResponseParser responseParser = new NoOpResponseParser();
        responseParser.setWriterType("json");
        ConnectStringParser parser = new ConnectStringParser(zookeeperConnectionString);
        CloudLegacySolrClient.Builder cloudBuilder = new CloudLegacySolrClient.Builder(parser.getServerAddresses().stream().map(address -> address.getHostString() + ":" + address.getPort()).collect(Collectors.toList()), Optional.ofNullable(parser.getChrootPath()));
        ((CloudLegacySolrClient.Builder)cloudBuilder.withConnectionTimeout(this.settings.getHttpConnectionTimeout())).withSocketTimeout(this.settings.getHttpReadTimeout());
        CloudLegacySolrClient client = cloudBuilder.build();
        client.setParser((ResponseParser)responseParser);
        client.connect();
        return client;
    }
}

