/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.external.ExternalizableInputStream;

public class JcrExternalizableInputStream
extends InputStream
implements ExternalizableInputStream {
    private final Property data;
    private final URI uri;
    private InputStream inputStream;

    JcrExternalizableInputStream(Property data, URI uri) {
        this.data = data;
        this.uri = uri;
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    private InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            try {
                this.inputStream = this.data.getBinary().getStream();
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return this.inputStream;
    }

    public URI getURI() {
        return this.uri;
    }
}

