/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.elasticsearch;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchInsertRequest;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchUpdateRequest;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexNameConverter;
import org.apache.skywalking.oap.server.library.client.elasticsearch.IndexNameMaker;
import org.apache.skywalking.oap.server.library.client.healthcheck.DelegatedHealthChecker;
import org.apache.skywalking.oap.server.library.client.healthcheck.HealthCheckable;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.util.HealthChecker;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements Client,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchClient.class);
    public static final String TYPE = "type";
    protected final String clusterNodes;
    protected final String protocol;
    private final String trustStorePath;
    private volatile String trustStorePass;
    private volatile String user;
    private volatile String password;
    private final List<IndexNameConverter> indexNameConverters;
    protected volatile RestHighLevelClient client;
    protected DelegatedHealthChecker healthChecker = new DelegatedHealthChecker();
    protected final ReentrantLock connectLock = new ReentrantLock();
    private final int connectTimeout;
    private final int socketTimeout;

    public ElasticSearchClient(String clusterNodes, String protocol, String trustStorePath, String trustStorePass, String user, String password, List<IndexNameConverter> indexNameConverters, int connectTimeout, int socketTimeout) {
        this.clusterNodes = clusterNodes;
        this.protocol = protocol;
        this.user = user;
        this.password = password;
        this.indexNameConverters = indexNameConverters;
        this.trustStorePath = trustStorePath;
        this.trustStorePass = trustStorePass;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void connect() throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, CertificateException {
        this.connectLock.lock();
        try {
            List<HttpHost> hosts = ElasticSearchClient.parseClusterNodes(this.protocol, this.clusterNodes);
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Throwable t) {
                    log.error("ElasticSearch client reconnection fails based on new config", t);
                }
            }
            this.client = this.createClient(hosts);
            this.client.ping(new Header[0]);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    protected RestHighLevelClient createClient(List<HttpHost> pairsList) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException {
        RestClientBuilder builder;
        if (StringUtil.isNotEmpty((String)this.user) && StringUtil.isNotEmpty((String)this.password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
            if (StringUtil.isEmpty((String)this.trustStorePath)) {
                builder = RestClient.builder((HttpHost[])pairsList.toArray(new HttpHost[0])).setHttpClientConfigCallback(arg_0 -> ElasticSearchClient.lambda$createClient$0((CredentialsProvider)credentialsProvider, arg_0));
            } else {
                KeyStore truststore = KeyStore.getInstance("jks");
                try (InputStream is = Files.newInputStream(Paths.get(this.trustStorePath, new String[0]), new OpenOption[0]);){
                    truststore.load(is, this.trustStorePass.toCharArray());
                }
                SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, null);
                SSLContext sslContext = sslBuilder.build();
                builder = RestClient.builder((HttpHost[])pairsList.toArray(new HttpHost[0])).setHttpClientConfigCallback(arg_0 -> ElasticSearchClient.lambda$createClient$1((CredentialsProvider)credentialsProvider, sslContext, arg_0));
            }
        } else {
            builder = RestClient.builder((HttpHost[])pairsList.toArray(new HttpHost[0]));
        }
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout));
        return new RestHighLevelClient(builder);
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }

    public static List<HttpHost> parseClusterNodes(String protocol, String nodes) {
        LinkedList<HttpHost> httpHosts = new LinkedList<HttpHost>();
        log.info("elasticsearch cluster nodes: {}", (Object)nodes);
        List nodesSplit = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)nodes);
        for (String node : nodesSplit) {
            String host = node.split(":")[0];
            String port = node.split(":")[1];
            httpHosts.add(new HttpHost(host, Integer.parseInt(port), protocol));
        }
        return httpHosts;
    }

    public boolean createIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        CreateIndexResponse response = this.client.indices().create(request, new Header[0]);
        log.debug("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean updateIndexMapping(String indexName, Map<String, Object> mapping) throws IOException {
        indexName = this.formatIndexName(indexName);
        Map properties = (Map)mapping.get(TYPE);
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName});
        Gson gson = new Gson();
        putMappingRequest.type(TYPE);
        putMappingRequest.source(gson.toJson((Object)properties), XContentType.JSON);
        PutMappingResponse response = this.client.indices().putMapping(putMappingRequest, new Header[0]);
        log.debug("put {} index mapping finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public Map<String, Object> getIndex(String indexName) throws IOException {
        if (StringUtil.isBlank((String)indexName)) {
            return new HashMap<String, Object>();
        }
        indexName = this.formatIndexName(indexName);
        try {
            Response response = this.client.getLowLevelClient().performRequest("GET", "/" + indexName, new Header[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                this.healthChecker.health();
                throw new IOException("The response status code of template exists request should be 200, but it is " + statusCode);
            }
            Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
            Map templates = (Map)new Gson().fromJson((Reader)new InputStreamReader(response.getEntity().getContent()), type);
            return Optional.ofNullable(templates.get(indexName)).orElse(new HashMap());
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                return new HashMap<String, Object>();
            }
            this.healthChecker.unHealth(e);
            throw e;
        }
        catch (IOException t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public boolean createIndex(String indexName, Map<String, Object> settings, Map<String, Object> mapping) throws IOException {
        indexName = this.formatIndexName(indexName);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        Gson gson = new Gson();
        request.settings(gson.toJson(settings), XContentType.JSON);
        request.mapping(TYPE, gson.toJson(mapping), XContentType.JSON);
        CreateIndexResponse response = this.client.indices().create(request, new Header[0]);
        log.debug("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public List<String> retrievalIndexByAliases(String aliases) throws IOException {
        Response response;
        aliases = this.formatIndexName(aliases);
        try {
            response = this.client.getLowLevelClient().performRequest("GET", "/_alias/" + aliases, new Header[0]);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
        if (200 == response.getStatusLine().getStatusCode()) {
            InputStreamReader reader;
            Gson gson = new Gson();
            try {
                reader = new InputStreamReader(response.getEntity().getContent());
            }
            catch (Throwable t) {
                this.healthChecker.unHealth(t);
                throw t;
            }
            JsonObject responseJson = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            log.debug("retrieval indexes by aliases {}, response is {}", (Object)aliases, (Object)responseJson);
            return new ArrayList<String>(responseJson.keySet());
        }
        return Collections.emptyList();
    }

    public boolean deleteByIndexName(String indexName) throws IOException {
        return this.deleteIndex(indexName, false);
    }

    public boolean deleteByModelName(String modelName) throws IOException {
        return this.deleteIndex(modelName, true);
    }

    protected boolean deleteIndex(String indexName, boolean formatIndexName) throws IOException {
        if (formatIndexName) {
            indexName = this.formatIndexName(indexName);
        }
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        DeleteIndexResponse response = this.client.indices().delete(request, new Header[0]);
        log.debug("delete {} index finished, isAcknowledged: {}", (Object)indexName, (Object)response.isAcknowledged());
        return response.isAcknowledged();
    }

    public boolean isExistsIndex(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{indexName});
        return this.client.indices().exists(request, new Header[0]);
    }

    public Map<String, Object> getTemplate(String name) throws IOException {
        name = this.formatIndexName(name);
        try {
            Response response = this.client.getLowLevelClient().performRequest("GET", "/_template/" + name, new Header[0]);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                this.healthChecker.health();
                throw new IOException("The response status code of template exists request should be 200, but it is " + statusCode);
            }
            Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
            Map templates = (Map)new Gson().fromJson((Reader)new InputStreamReader(response.getEntity().getContent()), type);
            if (templates.containsKey(name)) {
                return (Map)templates.get(name);
            }
            return new HashMap<String, Object>();
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                return new HashMap<String, Object>();
            }
            this.healthChecker.unHealth(e);
            throw e;
        }
        catch (IOException t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public boolean isExistsTemplate(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        Response response = this.client.getLowLevelClient().performRequest("HEAD", "/_template/" + indexName, new Header[0]);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return true;
        }
        if (statusCode == 404) {
            return false;
        }
        throw new IOException("The response status code of template exists request should be 200 or 404, but it is " + statusCode);
    }

    public boolean createOrUpdateTemplate(String indexName, Map<String, Object> settings, Map<String, Object> mapping, int order) throws IOException {
        indexName = this.formatIndexName(indexName);
        String[] patterns = new String[]{indexName + "-*"};
        HashMap<String, JsonObject> aliases = new HashMap<String, JsonObject>();
        aliases.put(indexName, new JsonObject());
        HashMap<String, Object> template = new HashMap<String, Object>();
        template.put("index_patterns", patterns);
        template.put("aliases", aliases);
        template.put("settings", settings);
        template.put("mappings", mapping);
        template.put("order", order);
        NStringEntity entity = new NStringEntity(new Gson().toJson(template), ContentType.APPLICATION_JSON);
        Response response = this.client.getLowLevelClient().performRequest("PUT", "/_template/" + indexName, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        return response.getStatusLine().getStatusCode() == 200;
    }

    public boolean deleteTemplate(String indexName) throws IOException {
        indexName = this.formatIndexName(indexName);
        Response response = this.client.getLowLevelClient().performRequest("DELETE", "/_template/" + indexName, new Header[0]);
        return response.getStatusLine().getStatusCode() == 200;
    }

    public SearchResponse search(IndexNameMaker indexNameMaker, SearchSourceBuilder searchSourceBuilder) throws IOException {
        String[] indexNames = (String[])Arrays.stream(indexNameMaker.make()).map(this::formatIndexName).toArray(String[]::new);
        return this.doSearch(searchSourceBuilder, indexNames);
    }

    public SearchResponse search(String indexName, SearchSourceBuilder searchSourceBuilder) throws IOException {
        indexName = this.formatIndexName(indexName);
        return this.doSearch(searchSourceBuilder, indexName);
    }

    protected SearchResponse doSearch(SearchSourceBuilder searchSourceBuilder, String ... indexNames) throws IOException {
        SearchRequest searchRequest = new SearchRequest(indexNames);
        searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)false));
        searchRequest.types(new String[]{TYPE});
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, new Header[0]);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            this.handleIOPoolStopped(t);
            throw t;
        }
    }

    protected void handleIOPoolStopped(Throwable t) throws IOException {
        if (!(t instanceof IllegalStateException)) {
            return;
        }
        IllegalStateException ise = (IllegalStateException)t;
        if (ise.getMessage().contains("I/O reactor status: STOPPED") && this.connectLock.tryLock()) {
            try {
                this.connect();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalStateException("Can't reconnect to Elasticsearch", e);
            }
        }
    }

    public GetResponse get(String indexName, String id) throws IOException {
        indexName = this.formatIndexName(indexName);
        GetRequest request = new GetRequest(indexName, TYPE, id);
        try {
            GetResponse response = this.client.get(request, new Header[0]);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public SearchResponse ids(String indexName, String[] ids) throws IOException {
        indexName = this.formatIndexName(indexName);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{TYPE});
        searchRequest.source().query((QueryBuilder)QueryBuilders.idsQuery().addIds(ids)).size(ids.length);
        try {
            SearchResponse response = this.client.search(searchRequest, new Header[0]);
            this.healthChecker.health();
            return response;
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public void forceInsert(String indexName, String id, XContentBuilder source) throws IOException {
        IndexRequest request = (IndexRequest)this.prepareInsert(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.client.index(request, new Header[0]);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public void forceUpdate(String indexName, String id, XContentBuilder source) throws IOException {
        UpdateRequest request = (UpdateRequest)this.prepareUpdate(indexName, id, source);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.client.update(request, new Header[0]);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
            throw t;
        }
    }

    public InsertRequest prepareInsert(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new ElasticSearchInsertRequest(indexName, TYPE, id).source(source);
    }

    public org.apache.skywalking.oap.server.library.client.request.UpdateRequest prepareUpdate(String indexName, String id, XContentBuilder source) {
        indexName = this.formatIndexName(indexName);
        return new ElasticSearchUpdateRequest(indexName, TYPE, id).doc(source);
    }

    public int delete(String indexName, String timeBucketColumnName, long endTimeBucket) throws IOException {
        indexName = this.formatIndexName(indexName);
        Map<String, String> params = Collections.singletonMap("conflicts", "proceed");
        String jsonString = "{  \"query\": {    \"range\": {      \"" + timeBucketColumnName + "\": {        \"lte\": " + endTimeBucket + "      }    }  }}";
        NStringEntity entity = new NStringEntity(jsonString, ContentType.APPLICATION_JSON);
        Response response = this.client.getLowLevelClient().performRequest("POST", "/" + indexName + "/_delete_by_query", params, (HttpEntity)entity, new Header[0]);
        log.debug("delete indexName: {}, jsonString : {}", (Object)indexName, (Object)jsonString);
        return response.getStatusLine().getStatusCode();
    }

    @Deprecated
    public void synchronousBulk(BulkRequest request) {
        request.timeout(TimeValue.timeValueMinutes((long)2L));
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        request.waitForActiveShards(ActiveShardCount.ONE);
        try {
            int size = request.requests().size();
            BulkResponse responses = this.client.bulk(request, new Header[0]);
            log.info("Synchronous bulk took time: {} millis, size: {}", (Object)responses.getTook().getMillis(), (Object)size);
            this.healthChecker.health();
        }
        catch (Throwable t) {
            this.healthChecker.unHealth(t);
        }
    }

    public BulkProcessor createBulkProcessor(int bulkActions, int flushInterval, int concurrentRequests) {
        BulkProcessor.Listener listener = this.createBulkListener();
        return BulkProcessor.builder((x$0, x$1) -> this.client.bulkAsync(x$0, x$1, new Header[0]), (BulkProcessor.Listener)listener).setBulkActions(bulkActions).setFlushInterval(TimeValue.timeValueSeconds((long)flushInterval)).setConcurrentRequests(concurrentRequests).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)3)).build();
    }

    protected BulkProcessor.Listener createBulkListener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                int numberOfActions = request.numberOfActions();
                log.debug("Executing bulk [{}] with {} requests", (Object)executionId, (Object)numberOfActions);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    log.warn("Bulk [{}] executed with failures:[{}]", (Object)executionId, (Object)response.buildFailureMessage());
                } else {
                    log.info("Bulk execution id [{}] completed in {} milliseconds, size: {}", new Object[]{executionId, response.getTook().getMillis(), request.requests().size()});
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                log.error("Failed to execute bulk", failure);
            }
        };
    }

    public String formatIndexName(String indexName) {
        for (IndexNameConverter indexNameConverter : this.indexNameConverters) {
            indexName = indexNameConverter.convert(indexName);
        }
        return indexName;
    }

    @Override
    public void registerChecker(HealthChecker healthChecker) {
        this.healthChecker.register(healthChecker);
    }

    @Generated
    public ElasticSearchClient(String clusterNodes, String protocol, String trustStorePath, List<IndexNameConverter> indexNameConverters, int connectTimeout, int socketTimeout) {
        this.clusterNodes = clusterNodes;
        this.protocol = protocol;
        this.trustStorePath = trustStorePath;
        this.indexNameConverters = indexNameConverters;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Generated
    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$1(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(sslContext);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

