/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.base.Strings;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.nacos.NacosConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.nacos.NacosServerSettings;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigurationProvider
extends AbstractConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfigurationProvider.class);
    private NacosServerSettings settings = new NacosServerSettings();

    public String name() {
        return "nacos";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        LOGGER.info("settings: {}", (Object)this.settings);
        if (Strings.isNullOrEmpty((String)this.settings.getServerAddr())) {
            throw new ModuleStartException("Nacos serverAddr cannot be null or empty.");
        }
        if (this.settings.getPort() <= 0) {
            throw new ModuleStartException("Nacos port must be positive integer.");
        }
        if (Strings.isNullOrEmpty((String)this.settings.getGroup())) {
            throw new ModuleStartException("Nacos group cannot be null or empty.");
        }
        if (StringUtil.isNotEmpty((String)this.settings.getUsername()) && StringUtil.isNotEmpty((String)this.settings.getAccessKey())) {
            throw new ModuleStartException("Nacos Auth method should choose either username or accessKey, not both");
        }
        try {
            return new NacosConfigWatcherRegister(this.settings);
        }
        catch (NacosException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }
}

