/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.server.polaris;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFile;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.factory.api.DiscoveryAPIFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.apache.shenyu.spi.Join;

@Join
public class PolarisClientServerRegisterRepository
implements ShenyuClientServerRegisterRepository {
    private ConsumerAPI consumerAPI;
    private ConfigFileService configFileService;
    private ShenyuClientServerRegisterPublisher publisher;
    private Properties props;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        Configuration configuration = this.buildConfiguration(config);
        SDKContext sdkContext = SDKContext.initContextByConfig((Configuration)configuration);
        this.consumerAPI = DiscoveryAPIFactory.createConsumerAPIByContext((SDKContext)sdkContext);
        this.publisher = publisher;
        this.configFileService = ConfigFileServiceFactory.createConfigFileService((SDKContext)sdkContext);
        this.props = config.getProps();
        this.subscribe();
    }

    private Configuration buildConfiguration(ShenyuRegisterCenterConfig config) {
        String serverLists = config.getServerLists();
        return ConfigAPIFactory.createConfigurationByAddress((String[])new String[]{serverLists});
    }

    private void subscribe() {
        RpcTypeEnum.acquireSupportMetadatas().forEach(this::subscribe);
    }

    private void subscribe(RpcTypeEnum rpcTypeEnum) {
        String namespace = this.props.getProperty("namespace", "default");
        String serviceName = RegisterPathConstants.buildServiceInstancePath((String)rpcTypeEnum.getName());
        String group = this.props.getProperty("fileGroup", "shenyu");
        WatchServiceRequest watchServiceRequest = WatchServiceRequest.builder().namespace(namespace).service(serviceName).listeners(Collections.singletonList(event -> {
            List allInstances = event.getAllInstances();
            for (Instance instance : allInstances) {
                if (!instance.isHealthy()) continue;
                Map metaMap = instance.getMetadata();
                URIRegisterDTO uriRegisterDTO = (URIRegisterDTO)GsonUtils.getInstance().fromJson(GsonUtils.getInstance().toJson((Object)metaMap), URIRegisterDTO.class);
                uriRegisterDTO.setPort(Integer.valueOf(instance.getPort()));
                uriRegisterDTO.setEventType(EventType.REGISTER);
                this.publisher.publish((DataTypeParent)uriRegisterDTO);
                String fileName = RegisterPathConstants.buildServiceConfigPath((String)uriRegisterDTO.getRpcType(), (String)uriRegisterDTO.getContextPath());
                ConfigFile configFile = this.configFileService.getConfigFile(namespace, group, fileName);
                List registerMetadataList = GsonUtils.getInstance().fromList(configFile.getContent(), MetaDataRegisterDTO.class);
                for (MetaDataRegisterDTO metaDataDto : registerMetadataList) {
                    this.publisher.publish((DataTypeParent)metaDataDto);
                }
            }
        })).build();
        this.consumerAPI.watchService(watchServiceRequest);
    }

    public void close() {
        this.consumerAPI.close();
        this.publisher.close();
    }
}

