/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;

public final class ExpressionExtractUtil {
    public static Collection<AndPredicate> getAndPredicates(ExpressionSegment expression) {
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        ExpressionExtractUtil.extractAndPredicates(result, expression);
        return result;
    }

    private static void extractAndPredicates(Collection<AndPredicate> result, ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            result.add(ExpressionExtractUtil.createAndPredicate(expression));
            return;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
        if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
            ExpressionExtractUtil.extractAndPredicates(result, binaryExpression.getLeft());
            ExpressionExtractUtil.extractAndPredicates(result, binaryExpression.getRight());
        } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
            Collection<AndPredicate> predicates = ExpressionExtractUtil.getAndPredicates(binaryExpression.getRight());
            for (AndPredicate each : ExpressionExtractUtil.getAndPredicates(binaryExpression.getLeft())) {
                ExpressionExtractUtil.extractCombinedAndPredicates(result, each, predicates);
            }
        } else {
            result.add(ExpressionExtractUtil.createAndPredicate(expression));
        }
    }

    private static void extractCombinedAndPredicates(Collection<AndPredicate> result, AndPredicate current, Collection<AndPredicate> predicates) {
        for (AndPredicate each : predicates) {
            AndPredicate predicate = new AndPredicate();
            predicate.getPredicates().addAll(current.getPredicates());
            predicate.getPredicates().addAll(each.getPredicates());
            result.add(predicate);
        }
    }

    private static AndPredicate createAndPredicate(ExpressionSegment expression) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().add(expression);
        return result;
    }

    public static List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions(Collection<ExpressionSegment> expressions) {
        ArrayList<ParameterMarkerExpressionSegment> result = new ArrayList<ParameterMarkerExpressionSegment>();
        ExpressionExtractUtil.extractParameterMarkerExpressions(result, expressions);
        return result;
    }

    private static void extractParameterMarkerExpressions(List<ParameterMarkerExpressionSegment> result, Collection<ExpressionSegment> expressions) {
        for (ExpressionSegment each : expressions) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.add((ParameterMarkerExpressionSegment)each);
            }
            if (each instanceof BinaryOperationExpression) {
                ExpressionExtractUtil.extractParameterMarkerExpressions(result, Collections.singletonList(((BinaryOperationExpression)each).getLeft()));
                ExpressionExtractUtil.extractParameterMarkerExpressions(result, Collections.singletonList(((BinaryOperationExpression)each).getRight()));
            }
            if (!(each instanceof FunctionSegment)) continue;
            ExpressionExtractUtil.extractParameterMarkerExpressions(result, ((FunctionSegment)each).getParameters());
        }
    }

    @Generated
    private ExpressionExtractUtil() {
    }
}

