/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.constant;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public enum DirectionType {
    NEXT("NEXT"),
    PRIOR("PRIOR"),
    FIRST("FIRST"),
    LAST("LAST"),
    ABSOLUTE_COUNT("ABSOLUTE"),
    RELATIVE_COUNT("RELATIVE"),
    COUNT(""),
    ALL("ALL"),
    FORWARD("FORWARD"),
    FORWARD_COUNT("FORWARD"),
    FORWARD_ALL("FORWARD ALL"),
    BACKWARD("BACKWARD"),
    BACKWARD_COUNT("BACKWARD"),
    BACKWARD_ALL("BACKWARD ALL");

    private static final Set<DirectionType> ALL_DIRECTION_TYPES;
    private static final Collection<DirectionType> FORWARD_COUNT_DIRECTION_TYPES;
    private static final Collection<DirectionType> BACKWARD_COUNT_DIRECTION_TYPES;
    private final String name;

    public static boolean isAllDirectionType(DirectionType directionType) {
        return ALL_DIRECTION_TYPES.contains((Object)directionType);
    }

    public static boolean isForwardCountDirectionType(DirectionType directionType) {
        return FORWARD_COUNT_DIRECTION_TYPES.contains((Object)directionType);
    }

    public static boolean isBackwardCountDirectionType(DirectionType directionType) {
        return BACKWARD_COUNT_DIRECTION_TYPES.contains((Object)directionType);
    }

    @Generated
    private DirectionType(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        ALL_DIRECTION_TYPES = new HashSet<DirectionType>(Arrays.asList(ALL, FORWARD_ALL, BACKWARD_ALL));
        FORWARD_COUNT_DIRECTION_TYPES = new HashSet<DirectionType>(Arrays.asList(NEXT, COUNT, FORWARD, FORWARD_COUNT));
        BACKWARD_COUNT_DIRECTION_TYPES = new HashSet<DirectionType>(Arrays.asList(PRIOR, BACKWARD, BACKWARD_COUNT));
    }
}

