/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.spring.namespace.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.shadow.algorithm.config.AlgorithmProvidedShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.spring.namespace.factorybean.ShadowAlgorithmFactoryBean;
import org.apache.shardingsphere.spring.namespace.registry.ShardingSphereAlgorithmBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ShadowRuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AlgorithmProvidedShadowRuleConfiguration.class);
        factory.addPropertyValue("dataSources", this.parseDataSourcesConfiguration(element));
        factory.addPropertyValue("tables", this.parseShadowTablesConfiguration(element));
        factory.addPropertyValue("defaultShadowAlgorithmName", (Object)this.parseDefaultShadowAlgorithmName(element));
        factory.addPropertyValue("shadowAlgorithms", (Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, ShadowAlgorithmFactoryBean.class));
        return factory.getBeanDefinition();
    }

    private Map<String, BeanDefinition> parseShadowTablesConfiguration(Element element) {
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)element, (String)"shadow-table");
        ManagedMap result = new ManagedMap(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.put(each.getAttribute("name"), this.parseShadowTableConfiguration(each));
        }
        return result;
    }

    private String parseDefaultShadowAlgorithmName(Element element) {
        Element defaultShadowAlgorithmElement = DomUtils.getChildElementByTagName((Element)element, (String)"default-shadow-algorithm-name");
        if (null == defaultShadowAlgorithmElement) {
            return null;
        }
        return defaultShadowAlgorithmElement.getAttribute("name");
    }

    private BeanDefinition parseShadowTableConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShadowTableConfiguration.class);
        factory.addConstructorArgValue(this.parseTableDataSourcesAttribute(element));
        factory.addConstructorArgValue(this.parseShadowAlgorithmNames(element));
        return factory.getBeanDefinition();
    }

    private Collection<String> parseTableDataSourcesAttribute(Element element) {
        String[] split = element.getAttribute("data-sources").split(",");
        return Arrays.stream(split).map(String::trim).collect(Collectors.toList());
    }

    private Collection<String> parseShadowAlgorithmNames(Element element) {
        List shadowAlgorithmElements = DomUtils.getChildElementsByTagName((Element)element, (String)"algorithm");
        ManagedList result = new ManagedList(shadowAlgorithmElements.size());
        for (Element each : shadowAlgorithmElements) {
            result.add(each.getAttribute("shadow-algorithm-ref"));
        }
        return result;
    }

    private Map<String, BeanDefinition> parseDataSourcesConfiguration(Element element) {
        List dataSourcesElements = DomUtils.getChildElementsByTagName((Element)element, (String)"data-source");
        ManagedMap result = new ManagedMap(dataSourcesElements.size());
        for (Element each : dataSourcesElements) {
            result.put(each.getAttribute("id"), this.parseDataSourceConfiguration(each));
        }
        return result;
    }

    private BeanDefinition parseDataSourceConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShadowDataSourceConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("production-data-source-name"));
        factory.addConstructorArgValue((Object)element.getAttribute("shadow-data-source-name"));
        return factory.getBeanDefinition();
    }
}

