/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.reactive.mysql.command.query.binary.execute;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.binary.BinaryRow;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLNewParametersBoundFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLBinaryResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLComStmtExecutePacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLEofPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary.MySQLPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.proxy.frontend.reactive.command.executor.ReactiveCommandExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;

public final class ReactiveMySQLComStmtExecuteExecutor
implements ReactiveCommandExecutor {
    private final MySQLComStmtExecutePacket packet;
    private final ConnectionSession connectionSession;
    private VertxDatabaseCommunicationEngine databaseCommunicationEngine;
    private ProxyBackendHandler proxyBackendHandler;
    private ResponseType responseType;
    private int currentSequenceId;

    public Future<Collection<DatabasePacket<?>>> executeFuture() {
        MySQLPreparedStatement preparedStatement = this.updateAndGetPreparedStatement();
        List parameters = this.packet.readParameters(preparedStatement.getParameterTypes(), preparedStatement.getLongData().keySet());
        preparedStatement.getLongData().forEach(parameters::set);
        SQLStatementContext sqlStatementContext = (SQLStatementContext)preparedStatement.getSqlStatementContext().get();
        if (sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)sqlStatementContext).setUpParameters(parameters);
        }
        QueryContext queryContext = new QueryContext(sqlStatementContext, preparedStatement.getSql(), parameters);
        this.connectionSession.setQueryContext(queryContext);
        SQLStatement sqlStatement = preparedStatement.getSqlStatement();
        String databaseName = this.connectionSession.getDatabaseName();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLCheckEngine.check((SQLStatementContext)sqlStatementContext, Collections.emptyList(), ReactiveMySQLComStmtExecuteExecutor.getRules(databaseName), (String)databaseName, (Map)metaDataContexts.getMetaData().getDatabases(), (Grantee)this.connectionSession.getGrantee());
        int characterSet = ((MySQLCharacterSet)this.connectionSession.getAttributeMap().attr(MySQLConstants.MYSQL_CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
        if (sqlStatement instanceof TCLStatement) {
            this.proxyBackendHandler = ProxyBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeFactory.getInstance((String)"MySQL"), (String)preparedStatement.getSql(), (SQLStatement)sqlStatement, (ConnectionSession)this.connectionSession);
        } else {
            this.databaseCommunicationEngine = (VertxDatabaseCommunicationEngine)DatabaseCommunicationEngineFactory.getInstance().newDatabaseCommunicationEngine(queryContext, this.connectionSession.getBackendConnection(), true);
        }
        return (null != this.databaseCommunicationEngine ? this.databaseCommunicationEngine.executeFuture() : this.proxyBackendHandler.executeFuture()).compose(responseHeader -> {
            Collection<DatabasePacket<?>> headerPackets = responseHeader instanceof QueryResponseHeader ? this.processQuery((QueryResponseHeader)responseHeader, characterSet) : this.processUpdate((UpdateResponseHeader)responseHeader);
            LinkedList result = new LinkedList(headerPackets);
            if (ResponseType.UPDATE == this.responseType) {
                return Future.succeededFuture(result);
            }
            try {
                while (this.next()) {
                    result.add((DatabasePacket<?>)this.getQueryRowPacket());
                }
                result.add((DatabasePacket<?>)new MySQLEofPacket(++this.currentSequenceId, ServerStatusFlagCalculator.calculateFor((ConnectionSession)this.connectionSession)));
                return Future.succeededFuture(result);
            }
            catch (SQLException ex) {
                return Future.failedFuture((Throwable)ex);
            }
        });
    }

    private MySQLPreparedStatement updateAndGetPreparedStatement() {
        MySQLPreparedStatement result = (MySQLPreparedStatement)this.connectionSession.getPreparedStatementRegistry().getPreparedStatement((Object)this.packet.getStatementId());
        if (MySQLNewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.packet.getNewParametersBoundFlag()) {
            result.setParameterTypes(this.packet.getNewParameterTypes());
        }
        return result;
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    private Collection<DatabasePacket<?>> processQuery(QueryResponseHeader queryResponseHeader, int characterSet) {
        this.responseType = ResponseType.QUERY;
        Collection result = ResponsePacketBuilder.buildQueryResponsePackets((QueryResponseHeader)queryResponseHeader, (int)characterSet, (int)ServerStatusFlagCalculator.calculateFor((ConnectionSession)this.connectionSession));
        this.currentSequenceId = result.size();
        return result;
    }

    private Collection<DatabasePacket<?>> processUpdate(UpdateResponseHeader updateResponseHeader) {
        this.responseType = ResponseType.UPDATE;
        return ResponsePacketBuilder.buildUpdateResponsePackets((UpdateResponseHeader)updateResponseHeader, (int)ServerStatusFlagCalculator.calculateFor((ConnectionSession)this.connectionSession));
    }

    private boolean next() throws SQLException {
        return null != this.databaseCommunicationEngine && this.databaseCommunicationEngine.next();
    }

    private MySQLPacket getQueryRowPacket() throws SQLException {
        QueryResponseRow queryResponseRow = this.databaseCommunicationEngine.getRowData();
        return new MySQLBinaryResultSetRowPacket(++this.currentSequenceId, this.createBinaryRow(queryResponseRow));
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        ArrayList<BinaryCell> result = new ArrayList<BinaryCell>(queryResponseRow.getCells().size());
        for (QueryResponseCell each : queryResponseRow.getCells()) {
            result.add(new BinaryCell((BinaryColumnType)MySQLBinaryColumnType.valueOfJDBCType((int)each.getJdbcType()), each.getData()));
        }
        return new BinaryRow(result);
    }

    public Future<Void> closeFuture() {
        try {
            if (null != this.proxyBackendHandler) {
                this.proxyBackendHandler.close();
            }
            return Future.succeededFuture();
        }
        catch (SQLException ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    @Generated
    public ReactiveMySQLComStmtExecuteExecutor(MySQLComStmtExecutePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

