/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.planner;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableFilterRule;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableProjectFilterRule;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableProjectRule;

public final class QueryOptimizePlannerFactory {
    private static final int DEFAULT_MATCH_LIMIT = 1024;

    public static RelOptPlanner createVolcanoPlanner() {
        VolcanoPlanner result = new VolcanoPlanner();
        QueryOptimizePlannerFactory.setUpRules((RelOptPlanner)result);
        return result;
    }

    public static RelOptPlanner createHepPlannerWithoutCalc() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getSubQueryRules()).addGroupEnd().addMatchOrder(HepMatchOrder.DEPTH_FIRST);
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getFilterRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getProjectRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addMatchLimit(1024);
        return new HepPlanner(builder.build());
    }

    public static RelOptPlanner createHepPlannerWithCalc() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getCalcRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addMatchLimit(1024);
        return new HepPlanner(builder.build());
    }

    public static RelOptPlanner createHepPlanner() {
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getSubQueryRules()).addGroupEnd().addMatchOrder(HepMatchOrder.DEPTH_FIRST);
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getFilterRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getProjectRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addGroupBegin().addRuleCollection(QueryOptimizePlannerFactory.getCalcRules()).addGroupEnd().addMatchOrder(HepMatchOrder.BOTTOM_UP);
        builder.addMatchLimit(1024);
        return new HepPlanner(builder.build());
    }

    private static void setUpRules(RelOptPlanner planner) {
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_CALC_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_SORT_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_AGGREGATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_RULE);
        planner.addRule(EnumerableRules.ENUMERABLE_CORRELATE_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_UNION_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE);
        planner.addRule((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE);
    }

    private static Collection<RelOptRule> getSubQueryRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE);
        result.add((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE);
        return result;
    }

    private static Collection<RelOptRule> getCalcRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)AggregateExpandDistinctAggregatesRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)CoreRules.PROJECT_TO_CALC);
        result.add((RelOptRule)CoreRules.FILTER_TO_CALC);
        result.add((RelOptRule)CoreRules.PROJECT_CALC_MERGE);
        result.add((RelOptRule)CoreRules.FILTER_CALC_MERGE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_TO_CALC_RULE);
        result.add((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_TO_CALC_RULE);
        result.add((RelOptRule)CoreRules.CALC_MERGE);
        return result;
    }

    private static Collection<RelOptRule> getProjectRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)AggregateExpandDistinctAggregatesRule.Config.DEFAULT.toRule());
        result.add((RelOptRule)CoreRules.PROJECT_CORRELATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_JOIN_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_WINDOW_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_FILTER_TRANSPOSE);
        result.add((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)ProjectRemoveRule.Config.DEFAULT.toRule());
        result.add(TranslatableProjectRule.INSTANCE);
        return result;
    }

    private static Collection<RelOptRule> getFilterRules() {
        LinkedList<RelOptRule> result = new LinkedList<RelOptRule>();
        result.add((RelOptRule)CoreRules.FILTER_INTO_JOIN);
        result.add((RelOptRule)CoreRules.JOIN_CONDITION_PUSH);
        result.add((RelOptRule)CoreRules.SORT_JOIN_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_AGGREGATE_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_PROJECT_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_SET_OP_TRANSPOSE);
        result.add((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_EXPRESSIONS);
        result.add((RelOptRule)CoreRules.JOIN_PUSH_TRANSITIVE_PREDICATES);
        result.add(TranslatableFilterRule.INSTANCE);
        result.add(TranslatableProjectFilterRule.INSTANCE);
        return result;
    }

    @Generated
    private QueryOptimizePlannerFactory() {
    }
}

