/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableSchema;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;

public final class TranslatableDatabase
extends AbstractSchema {
    private final String name;
    private final Map<String, Schema> subSchemaMap;

    public TranslatableDatabase(ShardingSphereDatabase database, TableScanExecutor executor) {
        this.name = database.getName();
        this.subSchemaMap = this.createSubSchemaMap(database, executor);
    }

    private Map<String, Schema> createSubSchemaMap(ShardingSphereDatabase database, TableScanExecutor executor) {
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>(database.getSchemas().size(), 1.0f);
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            result.put((String)entry.getKey(), (Schema)new TranslatableSchema((String)entry.getKey(), (ShardingSphereSchema)entry.getValue(), executor));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }
}

