/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.statement.select;

import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.context.ConverterContext;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.from.TableConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.groupby.GroupByConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.groupby.HavingConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.DistinctConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.ProjectionsConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.SQLStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class SelectStatementConverter
implements SQLStatementConverter<SelectStatement, SqlNode> {
    @Override
    public SqlNode convert(SelectStatement selectStatement) {
        SqlNodeList distinct = new DistinctConverter().convert(selectStatement.getProjections()).orElse(null);
        SqlNodeList projection = new ProjectionsConverter().convert(selectStatement.getProjections()).orElseThrow(IllegalStateException::new);
        SqlNode from = new TableConverter().convert(selectStatement.getFrom()).orElse(null);
        SqlNode where = selectStatement.getWhere().flatMap(optional -> new WhereConverter().convert((WhereSegment)optional)).orElse(null);
        SqlNodeList groupBy = selectStatement.getGroupBy().flatMap(optional -> new GroupByConverter().convert((GroupBySegment)optional)).orElse(null);
        SqlNode having = selectStatement.getHaving().flatMap(optional -> new HavingConverter().convert((HavingSegment)optional)).orElse(null);
        SqlNodeList orderBy = selectStatement.getOrderBy().flatMap(optional -> new OrderByConverter().convert((OrderBySegment)optional)).orElse(SqlNodeList.EMPTY);
        Optional limit = SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement);
        ConverterContext context = new ConverterContext();
        SqlSelect sqlSelect = new SqlSelect(SqlParserPos.ZERO, distinct, projection, from, where, groupBy, having, SqlNodeList.EMPTY, null, null, null, SqlNodeList.EMPTY);
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(optional -> new PaginationValueSQLConverter(context).convert((PaginationValueSegment)optional)).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(optional -> new PaginationValueSQLConverter(context).convert((PaginationValueSegment)optional)).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlSelect, orderBy, offset, rowCount);
        }
        return !orderBy.isEmpty() ? new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlSelect, orderBy, null, null) : sqlSelect;
    }
}

