/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.metadata.refresher;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.MetadataRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.AlterIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.AlterTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateViewStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropViewStatementSchemaRefresher;
import org.apache.shardingsphere.infra.optimize.core.metadata.refresher.type.AlterTableStatementFederateRefresher;
import org.apache.shardingsphere.infra.optimize.core.metadata.refresher.type.CreateTableStatementFederateRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropViewStatement;

public final class MetadataRefresherFactory {
    private static final Map<Class<?>, Collection<MetadataRefresher>> REGISTRY = new HashMap();

    public static Collection<MetadataRefresher> newInstance(SQLStatement sqlStatement) {
        for (Map.Entry<Class<?>, Collection<MetadataRefresher>> entry : REGISTRY.entrySet()) {
            if (!entry.getKey().isAssignableFrom(sqlStatement.getClass())) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    @Generated
    private MetadataRefresherFactory() {
    }

    static {
        REGISTRY.put(CreateTableStatement.class, new LinkedHashSet());
        REGISTRY.put(AlterTableStatement.class, new LinkedHashSet());
        REGISTRY.put(DropTableStatement.class, new LinkedHashSet());
        REGISTRY.put(CreateIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(AlterIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(DropIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(CreateViewStatement.class, new LinkedHashSet());
        REGISTRY.put(DropViewStatement.class, new LinkedHashSet());
        REGISTRY.get(CreateTableStatement.class).add((MetadataRefresher)new CreateTableStatementSchemaRefresher());
        REGISTRY.get(CreateTableStatement.class).add((MetadataRefresher)new CreateTableStatementFederateRefresher());
        REGISTRY.get(AlterTableStatement.class).add((MetadataRefresher)new AlterTableStatementSchemaRefresher());
        REGISTRY.get(AlterTableStatement.class).add((MetadataRefresher)new AlterTableStatementFederateRefresher());
        REGISTRY.get(DropTableStatement.class).add((MetadataRefresher)new DropTableStatementSchemaRefresher());
        REGISTRY.get(CreateIndexStatement.class).add((MetadataRefresher)new CreateIndexStatementSchemaRefresher());
        REGISTRY.get(AlterIndexStatement.class).add((MetadataRefresher)new AlterIndexStatementSchemaRefresher());
        REGISTRY.get(DropIndexStatement.class).add((MetadataRefresher)new DropIndexStatementSchemaRefresher());
        REGISTRY.get(CreateViewStatement.class).add((MetadataRefresher)new CreateViewStatementSchemaRefresher());
        REGISTRY.get(DropViewStatement.class).add((MetadataRefresher)new DropViewStatementSchemaRefresher());
    }
}

