/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.metadata.refresher;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.metadata.refresher.MetadataRefresherFactory;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.lock.LockNameUtil;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.metadata.MetadataRefresher;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.mapper.SQLStatementEventMapper;
import org.apache.shardingsphere.infra.metadata.mapper.SQLStatementEventMapperFactory;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.optimize.core.metadata.FederateSchemaMetadata;
import org.apache.shardingsphere.infra.optimize.core.metadata.refresher.FederateRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class MetadataRefreshEngine {
    private final ShardingSphereMetaData schemaMetadata;
    private final FederateSchemaMetadata federateMetadata;
    private final SchemaBuilderMaterials materials;
    private final ShardingSphereLock shardingSphereLock;

    public MetadataRefreshEngine(ShardingSphereMetaData schemaMetadata, FederateSchemaMetadata federateMetadata, ConfigurationProperties properties, ShardingSphereLock shardingSphereLock) {
        this.schemaMetadata = schemaMetadata;
        this.federateMetadata = federateMetadata;
        this.shardingSphereLock = shardingSphereLock;
        this.materials = new SchemaBuilderMaterials(schemaMetadata.getResource().getDatabaseType(), schemaMetadata.getResource().getDataSources(), schemaMetadata.getRuleMetaData().getRules(), properties);
    }

    public void refresh(SQLStatement sqlStatement, Collection<String> routeDataSourceNames) throws SQLException {
        Optional sqlStatementEventMapper;
        Collection<MetadataRefresher> metadataRefreshers = MetadataRefresherFactory.newInstance(sqlStatement);
        if (!metadataRefreshers.isEmpty()) {
            this.refresh(sqlStatement, routeDataSourceNames, metadataRefreshers);
        }
        if ((sqlStatementEventMapper = SQLStatementEventMapperFactory.newInstance((SQLStatement)sqlStatement)).isPresent()) {
            ShardingSphereEventBus.getInstance().post((Object)((SQLStatementEventMapper)sqlStatementEventMapper.get()).map(sqlStatement));
        }
    }

    private void refresh(SQLStatement sqlStatement, Collection<String> routeDataSourceNames, Collection<MetadataRefresher> refreshers) throws SQLException {
        if (Objects.nonNull(this.shardingSphereLock)) {
            this.refreshWithLock(sqlStatement, routeDataSourceNames, refreshers);
        } else {
            this.refreshWithoutLock(sqlStatement, routeDataSourceNames, refreshers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshWithLock(SQLStatement sqlStatement, Collection<String> routeDataSourceNames, Collection<MetadataRefresher> refreshers) throws SQLException {
        try {
            if (!this.shardingSphereLock.tryLock(LockNameUtil.getMetadataRefreshLockName())) {
                throw new ShardingSphereException("Metadata refresh failed.", new Object[0]);
            }
            this.refreshWithoutLock(sqlStatement, routeDataSourceNames, refreshers);
            if (!this.shardingSphereLock.isReleased(LockNameUtil.getMetadataRefreshLockName())) {
                throw new ShardingSphereException("Metadata refresh failed.", new Object[0]);
            }
        }
        finally {
            this.shardingSphereLock.releaseLock(LockNameUtil.getMetadataRefreshLockName());
        }
    }

    private void refreshWithoutLock(SQLStatement sqlStatement, Collection<String> routeDataSourceNames, Collection<MetadataRefresher> refreshers) throws SQLException {
        for (MetadataRefresher each : refreshers) {
            if (each instanceof SchemaRefresher) {
                ((SchemaRefresher)each).refresh(this.schemaMetadata.getSchema(), routeDataSourceNames, sqlStatement, this.materials);
            }
            if (!(each instanceof FederateRefresher)) continue;
            ((FederateRefresher)each).refresh(this.federateMetadata, routeDataSourceNames, sqlStatement, this.materials);
        }
        ShardingSphereEventBus.getInstance().post((Object)new SchemaAlteredEvent(this.schemaMetadata.getName(), this.schemaMetadata.getSchema()));
    }
}

