/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.metadata.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.metadata.MetaDataContexts;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.lock.ShardingSphereLock;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.optimize.context.OptimizeContextFactory;
import org.apache.shardingsphere.infra.state.StateContext;

public final class StandardMetaDataContexts
implements MetaDataContexts {
    private final Map<String, ShardingSphereMetaData> metaDataMap;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ExecutorEngine executorEngine;
    private final OptimizeContextFactory optimizeContextFactory;
    private final ConfigurationProperties props;
    private final StateContext stateContext;

    public StandardMetaDataContexts() {
        this(new LinkedHashMap<String, ShardingSphereMetaData>(), new ShardingSphereRuleMetaData(Collections.emptyList(), Collections.emptyList()), null, new ConfigurationProperties(new Properties()));
    }

    public StandardMetaDataContexts(Map<String, ShardingSphereMetaData> metaDataMap, ShardingSphereRuleMetaData globalRuleMetaData, ExecutorEngine executorEngine, ConfigurationProperties props) {
        this.metaDataMap = new LinkedHashMap<String, ShardingSphereMetaData>(metaDataMap);
        this.globalRuleMetaData = globalRuleMetaData;
        this.executorEngine = executorEngine;
        this.optimizeContextFactory = new OptimizeContextFactory(metaDataMap);
        this.props = props;
        this.stateContext = new StateContext();
    }

    @Override
    public Collection<String> getAllSchemaNames() {
        return this.metaDataMap.keySet();
    }

    @Override
    public ShardingSphereMetaData getMetaData(String schemaName) {
        return this.metaDataMap.get(schemaName);
    }

    @Override
    public ShardingSphereMetaData getDefaultMetaData() {
        return this.getMetaData("logic_db");
    }

    @Override
    public Optional<ShardingSphereLock> getLock() {
        return Optional.empty();
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }

    @Override
    @Generated
    public Map<String, ShardingSphereMetaData> getMetaDataMap() {
        return this.metaDataMap;
    }

    @Override
    @Generated
    public ShardingSphereRuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Override
    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    @Override
    @Generated
    public OptimizeContextFactory getOptimizeContextFactory() {
        return this.optimizeContextFactory;
    }

    @Override
    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Override
    @Generated
    public StateContext getStateContext() {
        return this.stateContext;
    }
}

