/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.DatabaseAccessConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.metadata.impl.StandardMetaDataContexts;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.resource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.resource.DataSourcesMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilder;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.ShardingSphereRulesBuilder;

public final class MetaDataContextsBuilder {
    private final Map<String, Map<String, DataSource>> dataSources;
    private final Map<String, Collection<RuleConfiguration>> schemaRuleConfigs;
    private final Collection<RuleConfiguration> globalRuleConfigs;
    private final ConfigurationProperties props;
    private final ExecutorEngine executorEngine;

    public MetaDataContextsBuilder(Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Properties props) {
        this(dataSources, schemaRuleConfigs, new LinkedList<RuleConfiguration>(), props);
    }

    public MetaDataContextsBuilder(Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        this.dataSources = dataSources;
        this.schemaRuleConfigs = schemaRuleConfigs;
        this.globalRuleConfigs = globalRuleConfigs;
        this.props = new ConfigurationProperties(null == props ? new Properties() : props);
        this.executorEngine = new ExecutorEngine(((Integer)this.props.getValue((Enum)ConfigurationPropertyKey.EXECUTOR_SIZE)).intValue());
    }

    public StandardMetaDataContexts build() throws SQLException {
        HashMap<String, ShardingSphereMetaData> mataDataMap = new HashMap<String, ShardingSphereMetaData>(this.schemaRuleConfigs.size(), 1.0f);
        for (String each : this.schemaRuleConfigs.keySet()) {
            mataDataMap.put(each, this.buildMetaData(each));
        }
        return new StandardMetaDataContexts(mataDataMap, this.buildGlobalSchemaMetaData(mataDataMap), this.executorEngine, this.props);
    }

    private ShardingSphereMetaData buildMetaData(String schemaName) throws SQLException {
        Map<String, DataSource> dataSourceMap = this.dataSources.get(schemaName);
        Collection<RuleConfiguration> ruleConfigs = this.schemaRuleConfigs.get(schemaName);
        DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(dataSourceMap.values());
        Collection rules = ShardingSphereRulesBuilder.buildSchemaRules((String)schemaName, ruleConfigs, (DatabaseType)databaseType, dataSourceMap);
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(ruleConfigs, rules);
        return new ShardingSphereMetaData(schemaName, this.buildResource(databaseType, dataSourceMap), ruleMetaData, this.buildSchema(databaseType, dataSourceMap, rules));
    }

    private ShardingSphereRuleMetaData buildGlobalSchemaMetaData(Map<String, ShardingSphereMetaData> mataDataMap) {
        return new ShardingSphereRuleMetaData(this.globalRuleConfigs, ShardingSphereRulesBuilder.buildGlobalRules(this.globalRuleConfigs, mataDataMap));
    }

    private ShardingSphereResource buildResource(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) throws SQLException {
        DataSourcesMetaData dataSourceMetas = new DataSourcesMetaData(databaseType, this.getDatabaseAccessConfigurationMap(dataSourceMap));
        CachedDatabaseMetaData cachedDatabaseMetaData = this.createCachedDatabaseMetaData(dataSourceMap).orElse(null);
        return new ShardingSphereResource(dataSourceMap, dataSourceMetas, cachedDatabaseMetaData, databaseType);
    }

    private Map<String, DatabaseAccessConfiguration> getDatabaseAccessConfigurationMap(Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedHashMap<String, DatabaseAccessConfiguration> result = new LinkedHashMap<String, DatabaseAccessConfiguration>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            DataSource dataSource = entry.getValue();
            Connection connection = dataSource.getConnection();
            Throwable throwable = null;
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                result.put(entry.getKey(), new DatabaseAccessConfiguration(metaData.getURL(), metaData.getUserName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                connection.close();
            }
        }
        return result;
    }

    private Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }

    private ShardingSphereSchema buildSchema(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) throws SQLException {
        return SchemaBuilder.build((SchemaBuilderMaterials)new SchemaBuilderMaterials(databaseType, dataSourceMap, rules, this.props));
    }
}

