/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.parser.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.AbstractDatabaseDiscoverySegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryConstructionSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryDefinitionSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryHeartbeatSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryTypeSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryHeartbeatsStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryTypesStatement;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.DatabaseDiscoveryDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DatabaseDiscoveryDistSQLStatementVisitor
extends DatabaseDiscoveryDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.CreateDatabaseDiscoveryRuleContext ctx) {
        return new CreateDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRule().stream().map(each -> (AbstractDatabaseDiscoverySegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.AlterDatabaseDiscoveryRuleContext ctx) {
        return new AlterDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRule().stream().map(each -> (AbstractDatabaseDiscoverySegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryRuleContext ctx) {
        if (null != ctx.databaseDiscoveryRuleDefinition()) {
            return (ASTNode)this.visit((ParseTree)ctx.databaseDiscoveryRuleDefinition());
        }
        return (ASTNode)this.visit((ParseTree)ctx.databaseDiscoveryRuleConstruction());
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRuleConstruction(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryRuleConstructionContext ctx) {
        return new DatabaseDiscoveryConstructionSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildResources(ctx.resources()), this.getIdentifierValue((ParseTree)ctx.discoveryTypeName()), this.getIdentifierValue((ParseTree)ctx.discoveryHeartbeatName()));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRuleDefinition(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryRuleDefinitionContext ctx) {
        return new DatabaseDiscoveryDefinitionSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), this.buildResources(ctx.resources()), (AlgorithmSegment)this.visit((ParseTree)ctx.typeDefinition()), this.getProperties(ctx.discoveryHeartbeat().properties()));
    }

    private List<String> buildResources(DatabaseDiscoveryDistSQLStatementParser.ResourcesContext ctx) {
        return ctx.resourceName().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList());
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryRule(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryRuleContext ctx) {
        return new DropDatabaseDiscoveryRuleStatement((Collection)ctx.ruleName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()), null != ctx.existClause());
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryRules(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryRulesContext ctx) {
        return new ShowDatabaseDiscoveryRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitCreateDatabaseDiscoveryHeartbeat(DatabaseDiscoveryDistSQLStatementParser.CreateDatabaseDiscoveryHeartbeatContext ctx) {
        return new CreateDatabaseDiscoveryHeartbeatStatement((Collection)ctx.heartbeatDefinition().stream().map(each -> new DatabaseDiscoveryHeartbeatSegment(this.getIdentifierValue((ParseTree)each.discoveryHeartbeatName()), this.getProperties(each.properties()))).collect(Collectors.toCollection(LinkedList::new)));
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryHeartbeat(DatabaseDiscoveryDistSQLStatementParser.AlterDatabaseDiscoveryHeartbeatContext ctx) {
        return new AlterDatabaseDiscoveryHeartbeatStatement((Collection)ctx.heartbeatDefinition().stream().map(each -> new DatabaseDiscoveryHeartbeatSegment(this.getIdentifierValue((ParseTree)each.discoveryHeartbeatName()), this.getProperties(each.properties()))).collect(Collectors.toCollection(LinkedList::new)));
    }

    @Override
    public ASTNode visitCreateDatabaseDiscoveryType(DatabaseDiscoveryDistSQLStatementParser.CreateDatabaseDiscoveryTypeContext ctx) {
        return new CreateDatabaseDiscoveryTypeStatement(this.buildAlgorithmEntry(ctx.databaseDiscoveryTypeDefinition()));
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryType(DatabaseDiscoveryDistSQLStatementParser.AlterDatabaseDiscoveryTypeContext ctx) {
        return new AlterDatabaseDiscoveryTypeStatement(this.buildAlgorithmEntry(ctx.databaseDiscoveryTypeDefinition()));
    }

    private Collection<DatabaseDiscoveryTypeSegment> buildAlgorithmEntry(List<DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryTypeDefinitionContext> ctx) {
        return ctx.stream().map(each -> (DatabaseDiscoveryTypeSegment)this.visit((ParseTree)each)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryTypeDefinition(DatabaseDiscoveryDistSQLStatementParser.DatabaseDiscoveryTypeDefinitionContext ctx) {
        return new DatabaseDiscoveryTypeSegment(this.getIdentifierValue((ParseTree)ctx.discoveryTypeName()), (AlgorithmSegment)this.visit((ParseTree)ctx.typeDefinition()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryTypes(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryTypesContext ctx) {
        return new ShowDatabaseDiscoveryTypesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryHeartbeats(DatabaseDiscoveryDistSQLStatementParser.ShowDatabaseDiscoveryHeartbeatsContext ctx) {
        return new ShowDatabaseDiscoveryHeartbeatsStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitSchemaName(DatabaseDiscoveryDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitTypeDefinition(DatabaseDiscoveryDistSQLStatementParser.TypeDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.discoveryTypeName()), null == ctx.properties() ? new Properties() : this.getProperties(ctx.properties()));
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryType(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryTypeContext ctx) {
        return new DropDatabaseDiscoveryTypeStatement((Collection)ctx.discoveryTypeName().stream().map(this::getIdentifierValue).collect(Collectors.toCollection(LinkedList::new)), null != ctx.existClause());
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryHeartbeat(DatabaseDiscoveryDistSQLStatementParser.DropDatabaseDiscoveryHeartbeatContext ctx) {
        return new DropDatabaseDiscoveryHeartbeatStatement((Collection)ctx.discoveryHeartbeatName().stream().map(this::getIdentifierValue).collect(Collectors.toCollection(LinkedList::new)), null != ctx.existClause());
    }

    private Properties getProperties(DatabaseDiscoveryDistSQLStatementParser.PropertiesContext ctx) {
        Properties result = new Properties();
        for (DatabaseDiscoveryDistSQLStatementParser.PropertyContext each : ctx.property()) {
            result.setProperty(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText()));
        }
        return result;
    }
}

