/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class DropDatabaseDiscoveryTypeStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryTypeStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkIsExist(schemaName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkIsExist(String schemaName, DropDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set currentRuleNames = currentRuleConfig.getDiscoveryTypes().keySet();
        Collection notExistedRuleNames = sqlStatement.getTypes().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName, notExistedRuleNames));
    }

    private void checkIsInUse(String schemaName, DropDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection heartbeatInUse = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getDiscoveryTypeName).collect(Collectors.toSet());
        Collection invalid = sqlStatement.getTypes().stream().filter(heartbeatInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), (DistSQLException)new RuleInUsedException(RULE_TYPE, schemaName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getTypes()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String typeName) {
        if (this.isNotInUse(currentRuleConfig, typeName)) {
            currentRuleConfig.getDiscoveryTypes().remove(typeName);
        }
    }

    private boolean isNotInUse(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String toBeDroppedDiscoveryTypeName) {
        return currentRuleConfig.getDataSources().stream().noneMatch(each -> each.getDiscoveryTypeName().equals(toBeDroppedDiscoveryTypeName));
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryTypeStatement.class.getName();
    }
}

