/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.DropDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class DropDatabaseDiscoveryHeartbeatStatementUpdater
implements RuleDefinitionDropUpdater<DropDatabaseDiscoveryHeartbeatStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkIsExist(schemaName, sqlStatement, currentRuleConfig);
        this.checkIsInUse(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkIsExist(String schemaName, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set currentRuleNames = currentRuleConfig.getDiscoveryHeartbeats().keySet();
        Collection notExistedRuleNames = sqlStatement.getHeartbeatNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedRuleNames.isEmpty(), (DistSQLException)new RequiredRuleMissedException(RULE_TYPE, schemaName, notExistedRuleNames));
    }

    private void checkIsInUse(String schemaName, DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection heartbeatInUse = currentRuleConfig.getDataSources().stream().map(DatabaseDiscoveryDataSourceRuleConfiguration::getDiscoveryHeartbeatName).collect(Collectors.toSet());
        Collection invalid = sqlStatement.getHeartbeatNames().stream().filter(heartbeatInUse::contains).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalid.isEmpty(), (DistSQLException)new RuleInUsedException(RULE_TYPE, schemaName, invalid));
    }

    public boolean updateCurrentRuleConfiguration(DropDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getHeartbeatNames()) {
            this.dropRule(currentRuleConfig, each);
        }
        return false;
    }

    private void dropRule(DatabaseDiscoveryRuleConfiguration currentRuleConfig, String heartbeatName) {
        currentRuleConfig.getDiscoveryHeartbeats().remove(heartbeatName);
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return DropDatabaseDiscoveryHeartbeatStatement.class.getName();
    }
}

