/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.spark.common.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class TypeConverterUtils {
    private static final Map<DataType, SeaTunnelDataType<?>> TO_SEA_TUNNEL_TYPES = new HashMap(16);
    public static final String ROW_KIND_FIELD = "op";

    private TypeConverterUtils() {
        throw new UnsupportedOperationException("TypeConverterUtils is a utility class and cannot be instantiated");
    }

    public static DataType convert(SeaTunnelDataType<?> dataType) {
        Preconditions.checkNotNull(dataType, "The SeaTunnel's data type is required.");
        switch (dataType.getSqlType()) {
            case NULL: {
                return DataTypes.NullType;
            }
            case STRING: {
                return DataTypes.StringType;
            }
            case BOOLEAN: {
                return DataTypes.BooleanType;
            }
            case TINYINT: {
                return DataTypes.ByteType;
            }
            case SMALLINT: {
                return DataTypes.ShortType;
            }
            case INT: {
                return DataTypes.IntegerType;
            }
            case BIGINT: {
                return DataTypes.LongType;
            }
            case FLOAT: {
                return DataTypes.FloatType;
            }
            case DOUBLE: {
                return DataTypes.DoubleType;
            }
            case BYTES: {
                return DataTypes.BinaryType;
            }
            case DATE: {
                return DataTypes.DateType;
            }
            case TIMESTAMP: {
                return DataTypes.TimestampType;
            }
            case ARRAY: {
                return DataTypes.createArrayType((DataType)TypeConverterUtils.convert(((org.apache.seatunnel.api.table.type.ArrayType)dataType).getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                return DataTypes.createMapType((DataType)TypeConverterUtils.convert(mapType.getKeyType()), (DataType)TypeConverterUtils.convert(mapType.getValueType()));
            }
            case DECIMAL: {
                org.apache.seatunnel.api.table.type.DecimalType decimalType = (org.apache.seatunnel.api.table.type.DecimalType)dataType;
                return new DecimalType(decimalType.getPrecision(), decimalType.getScale());
            }
            case ROW: {
                return TypeConverterUtils.convert((SeaTunnelRowType)dataType);
            }
        }
        throw new IllegalArgumentException("Unsupported SeaTunnel's data type: " + dataType);
    }

    private static StructType convert(SeaTunnelRowType rowType) {
        StructField[] fields = new StructField[rowType.getFieldNames().length];
        for (int i = 0; i < rowType.getFieldNames().length; ++i) {
            fields[i] = new StructField(rowType.getFieldNames()[i], TypeConverterUtils.convert(rowType.getFieldTypes()[i]), true, Metadata.empty());
        }
        return new StructType(fields);
    }

    public static SeaTunnelDataType<?> convert(DataType sparkType) {
        Preconditions.checkNotNull(sparkType, "The Spark's data type is required.");
        SeaTunnelDataType<?> dataType = TO_SEA_TUNNEL_TYPES.get(sparkType);
        if (dataType != null) {
            return dataType;
        }
        if (sparkType instanceof ArrayType) {
            return TypeConverterUtils.convert((ArrayType)sparkType);
        }
        if (sparkType instanceof org.apache.spark.sql.types.MapType) {
            org.apache.spark.sql.types.MapType mapType = (org.apache.spark.sql.types.MapType)sparkType;
            return new MapType(TypeConverterUtils.convert(mapType.keyType()), TypeConverterUtils.convert(mapType.valueType()));
        }
        if (sparkType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)sparkType;
            return new org.apache.seatunnel.api.table.type.DecimalType(decimalType.precision(), decimalType.scale());
        }
        if (sparkType instanceof StructType) {
            return TypeConverterUtils.convert((StructType)sparkType);
        }
        throw new IllegalArgumentException("Unsupported Spark's data type: " + sparkType.sql());
    }

    private static org.apache.seatunnel.api.table.type.ArrayType<?, ?> convert(ArrayType arrayType) {
        switch (TypeConverterUtils.convert(arrayType.elementType()).getSqlType()) {
            case STRING: {
                return org.apache.seatunnel.api.table.type.ArrayType.STRING_ARRAY_TYPE;
            }
            case BOOLEAN: {
                return org.apache.seatunnel.api.table.type.ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case TINYINT: {
                return org.apache.seatunnel.api.table.type.ArrayType.BYTE_ARRAY_TYPE;
            }
            case SMALLINT: {
                return org.apache.seatunnel.api.table.type.ArrayType.SHORT_ARRAY_TYPE;
            }
            case INT: {
                return org.apache.seatunnel.api.table.type.ArrayType.INT_ARRAY_TYPE;
            }
            case BIGINT: {
                return org.apache.seatunnel.api.table.type.ArrayType.LONG_ARRAY_TYPE;
            }
            case FLOAT: {
                return org.apache.seatunnel.api.table.type.ArrayType.FLOAT_ARRAY_TYPE;
            }
            case DOUBLE: {
                return org.apache.seatunnel.api.table.type.ArrayType.DOUBLE_ARRAY_TYPE;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported Spark's array type: %s.", arrayType.sql()));
    }

    private static SeaTunnelRowType convert(StructType structType) {
        StructField[] structFields = structType.fields();
        String[] fieldNames = new String[structFields.length];
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[structFields.length];
        for (int i = 0; i < structFields.length; ++i) {
            fieldNames[i] = structFields[i].name();
            fieldTypes[i] = TypeConverterUtils.convert(structFields[i].dataType());
        }
        return new SeaTunnelRowType(fieldNames, fieldTypes);
    }

    static {
        TO_SEA_TUNNEL_TYPES.put(DataTypes.NullType, BasicType.VOID_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.StringType, BasicType.STRING_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.BooleanType, BasicType.BOOLEAN_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.ByteType, BasicType.BYTE_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.ShortType, BasicType.SHORT_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.IntegerType, BasicType.INT_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.LongType, BasicType.LONG_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.FloatType, BasicType.FLOAT_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.DoubleType, BasicType.DOUBLE_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.BinaryType, PrimitiveByteArrayType.INSTANCE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.DateType, LocalTimeType.LOCAL_DATE_TYPE);
        TO_SEA_TUNNEL_TYPES.put(DataTypes.TimestampType, LocalTimeType.LOCAL_DATE_TIME_TYPE);
    }
}

