/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public final class SparkStructTypeUtil {
    private SparkStructTypeUtil() {
    }

    public static StructType getStructType(StructType schema, ObjectNode json) {
        StructType newSchema = schema.copy(schema.fields());
        Map<String, Object> jsonMap = JsonUtils.toMap(json);
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            String field2 = entry.getKey();
            Object type = entry.getValue();
            if (type instanceof ObjectNode) {
                StructType st = SparkStructTypeUtil.getStructType(new StructType(), (ObjectNode)type);
                newSchema = newSchema.add(field2, (DataType)st);
                continue;
            }
            if (type instanceof List) {
                DataType st;
                List list = (List)type;
                if (list.size() == 0) {
                    newSchema = newSchema.add(field2, (DataType)DataTypes.createArrayType(null, (boolean)true));
                    continue;
                }
                Object o = list.get(0);
                if (o instanceof ObjectNode) {
                    st = SparkStructTypeUtil.getStructType(new StructType(), (ObjectNode)o);
                    newSchema = newSchema.add(field2, (DataType)DataTypes.createArrayType((DataType)st, (boolean)true));
                    continue;
                }
                st = SparkStructTypeUtil.getType(o.toString());
                newSchema = newSchema.add(field2, (DataType)DataTypes.createArrayType((DataType)st, (boolean)true));
                continue;
            }
            newSchema = newSchema.add(field2, SparkStructTypeUtil.getType(type.toString()));
        }
        return newSchema;
    }

    private static DataType getType(String type) {
        DataType dataType;
        switch (type.toLowerCase()) {
            case "string": {
                dataType = DataTypes.StringType;
                break;
            }
            case "integer": {
                dataType = DataTypes.IntegerType;
                break;
            }
            case "long": {
                dataType = DataTypes.LongType;
                break;
            }
            case "double": {
                dataType = DataTypes.DoubleType;
                break;
            }
            case "float": {
                dataType = DataTypes.FloatType;
                break;
            }
            case "short": {
                dataType = DataTypes.ShortType;
                break;
            }
            case "date": {
                dataType = DataTypes.DateType;
                break;
            }
            case "timestamp": {
                dataType = DataTypes.TimestampType;
                break;
            }
            case "boolean": {
                dataType = DataTypes.BooleanType;
                break;
            }
            case "binary": {
                dataType = DataTypes.BinaryType;
                break;
            }
            case "byte": {
                dataType = DataTypes.ByteType;
                break;
            }
            default: {
                throw new ConfigRuntimeException("Throw data type exception, unknown type: " + type);
            }
        }
        return dataType;
    }
}

