/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.config;

import java.nio.file.Path;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigResolveOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBuilder.class);
    private static final String PLUGIN_NAME_KEY = "plugin_name";
    private final Path configFile;
    private final Config config;

    public ConfigBuilder(Path configFile) {
        this.configFile = configFile;
        this.config = this.load();
    }

    private Config load() {
        if (this.configFile == null) {
            throw new ConfigRuntimeException("Please specify config file");
        }
        log.info("Loading config file: {}", (Object)this.configFile);
        Config config = ConfigFactory.parseFile(this.configFile.toFile()).resolve(ConfigResolveOptions.defaults().setAllowUnresolved(true)).resolveWith(ConfigFactory.systemProperties(), ConfigResolveOptions.defaults().setAllowUnresolved(true));
        ConfigRenderOptions options = ConfigRenderOptions.concise().setFormatted(true);
        log.info("parsed config file: {}", (Object)config.root().render(options));
        return config;
    }

    public Config getConfig() {
        return this.config;
    }
}

