/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.util.Objects;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

public class BasicType<T>
implements SeaTunnelDataType<T> {
    private static final long serialVersionUID = 2L;
    public static final BasicType<String> STRING_TYPE = new BasicType<String>(String.class, SqlType.STRING);
    public static final BasicType<Boolean> BOOLEAN_TYPE = new BasicType<Boolean>(Boolean.class, SqlType.BOOLEAN);
    public static final BasicType<Byte> BYTE_TYPE = new BasicType<Byte>(Byte.class, SqlType.TINYINT);
    public static final BasicType<Short> SHORT_TYPE = new BasicType<Short>(Short.class, SqlType.SMALLINT);
    public static final BasicType<Integer> INT_TYPE = new BasicType<Integer>(Integer.class, SqlType.INT);
    public static final BasicType<Long> LONG_TYPE = new BasicType<Long>(Long.class, SqlType.BIGINT);
    public static final BasicType<Float> FLOAT_TYPE = new BasicType<Float>(Float.class, SqlType.FLOAT);
    public static final BasicType<Double> DOUBLE_TYPE = new BasicType<Double>(Double.class, SqlType.DOUBLE);
    public static final BasicType<Void> VOID_TYPE = new BasicType<Void>(Void.class, SqlType.NULL);
    private final Class<T> typeClass;
    private final SqlType sqlType;

    protected BasicType(Class<T> typeClass, SqlType sqlType) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicType)) {
            return false;
        }
        BasicType that = (BasicType)obj;
        return Objects.equals(this.typeClass, that.typeClass) && Objects.equals((Object)this.sqlType, (Object)that.sqlType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeClass, this.sqlType});
    }

    public String toString() {
        return this.sqlType.toString();
    }
}

