/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.configuration.util.RequiredOption;

public class OptionRule {
    private final List<Option<?>> optionalOptions;
    private final List<RequiredOption> requiredOptions;

    OptionRule(List<Option<?>> optionalOptions, List<RequiredOption> requiredOptions) {
        this.optionalOptions = optionalOptions;
        this.requiredOptions = requiredOptions;
    }

    public List<Option<?>> getOptionalOptions() {
        return this.optionalOptions;
    }

    public List<RequiredOption> getRequiredOptions() {
        return this.requiredOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionRule)) {
            return false;
        }
        OptionRule that = (OptionRule)o;
        return Objects.equals(this.optionalOptions, that.optionalOptions) && Objects.equals(this.requiredOptions, that.requiredOptions);
    }

    public int hashCode() {
        return Objects.hash(this.optionalOptions, this.requiredOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Option<?>> optionalOptions = new ArrayList();
        private final List<RequiredOption> requiredOptions = new ArrayList<RequiredOption>();

        private Builder() {
        }

        public Builder optional(Option<?> ... options) {
            if (options == null) {
                throw new NullPointerException("options is marked @NonNull but is null");
            }
            for (Option<?> option : options) {
                this.verifyDuplicate(option, "OptionsOption");
            }
            this.optionalOptions.addAll(Arrays.asList(options));
            return this;
        }

        public Builder required(Option<?> ... options) {
            if (options == null) {
                throw new NullPointerException("options is marked @NonNull but is null");
            }
            for (Option<?> option : options) {
                this.verifyDuplicate(option, "RequiredOption");
                this.verifyRequiredOptionDefaultValue(option);
            }
            this.requiredOptions.add(RequiredOption.AbsolutelyRequiredOptions.of(options));
            return this;
        }

        public Builder exclusive(Option<?> ... options) {
            if (options == null) {
                throw new NullPointerException("options is marked @NonNull but is null");
            }
            if (options.length <= 1) {
                throw new OptionValidationException("The number of exclusive options must be greater than 1.");
            }
            for (Option<?> option : options) {
                this.verifyDuplicate(option, "ExclusiveOption");
                this.verifyRequiredOptionDefaultValue(option);
            }
            this.requiredOptions.add(RequiredOption.ExclusiveRequiredOptions.of(options));
            return this;
        }

        public <T> Builder conditional(@NonNull Option<T> conditionalOption, @NonNull List<T> expectValues, Option<?> ... requiredOptions) {
            if (conditionalOption == null) {
                throw new NullPointerException("conditionalOption is marked @NonNull but is null");
            }
            if (expectValues == null) {
                throw new NullPointerException("expectValues is marked @NonNull but is null");
            }
            if (requiredOptions == null) {
                throw new NullPointerException("requiredOptions is marked @NonNull but is null");
            }
            for (Option<?> o : requiredOptions) {
                this.verifyDuplicate(o, "ConditionalOption");
                this.verifyRequiredOptionDefaultValue(o);
            }
            this.verifyConditionalExists(conditionalOption);
            if (expectValues.size() == 0) {
                throw new OptionValidationException(String.format("conditional option '%s' must have expect values .", conditionalOption.key()));
            }
            Expression expression = Expression.of(Condition.of(conditionalOption, expectValues.get(0)));
            for (int i = 0; i < expectValues.size(); ++i) {
                if (i == 0) continue;
                expression = expression.or(Expression.of(Condition.of(conditionalOption, expectValues.get(i))));
            }
            this.requiredOptions.add(RequiredOption.ConditionalRequiredOptions.of(expression, new ArrayList(Arrays.asList(requiredOptions))));
            return this;
        }

        public <T> Builder conditional(@NonNull Option<T> conditionalOption, @NonNull T expectValue, Option<?> ... requiredOptions) {
            if (conditionalOption == null) {
                throw new NullPointerException("conditionalOption is marked @NonNull but is null");
            }
            if (expectValue == null) {
                throw new NullPointerException("expectValue is marked @NonNull but is null");
            }
            if (requiredOptions == null) {
                throw new NullPointerException("requiredOptions is marked @NonNull but is null");
            }
            for (Option<?> o : requiredOptions) {
                this.verifyDuplicate(o, "ConditionalOption");
                this.verifyRequiredOptionDefaultValue(o);
            }
            this.verifyConditionalExists(conditionalOption);
            Expression expression = Expression.of(Condition.of(conditionalOption, expectValue));
            this.requiredOptions.add(RequiredOption.ConditionalRequiredOptions.of(expression, new ArrayList(Arrays.asList(requiredOptions))));
            return this;
        }

        public Builder bundled(Option<?> ... requiredOptions) {
            if (requiredOptions == null) {
                throw new NullPointerException("requiredOptions is marked @NonNull but is null");
            }
            for (Option<?> option : requiredOptions) {
                this.verifyDuplicate(option, "BundledOption");
            }
            this.requiredOptions.add(RequiredOption.BundledRequiredOptions.of(requiredOptions));
            return this;
        }

        public OptionRule build() {
            return new OptionRule(this.optionalOptions, this.requiredOptions);
        }

        private void verifyRequiredOptionDefaultValue(@NonNull Option<?> option) {
            if (option == null) {
                throw new NullPointerException("option is marked @NonNull but is null");
            }
            if (option.defaultValue() != null) {
                throw new OptionValidationException(String.format("Required option '%s' should have no default value.", option.key()));
            }
        }

        private void verifyDuplicate(@NonNull Option<?> option, @NonNull String currentOptionType) {
            if (option == null) {
                throw new NullPointerException("option is marked @NonNull but is null");
            }
            if (currentOptionType == null) {
                throw new NullPointerException("currentOptionType is marked @NonNull but is null");
            }
            if (this.optionalOptions.contains(option)) {
                throw new OptionValidationException(String.format("%s '%s' duplicate in option options.", currentOptionType, option.key()));
            }
            this.requiredOptions.forEach(requiredOption -> {
                if (requiredOption.getOptions().contains(option)) {
                    throw new OptionValidationException(String.format("%s '%s' duplicate in '%s'.", currentOptionType, option.key(), requiredOption.getClass().getName()));
                }
            });
        }

        private void verifyConditionalExists(@NonNull Option<?> option) {
            if (option == null) {
                throw new NullPointerException("option is marked @NonNull but is null");
            }
            boolean inOptions = this.optionalOptions.contains(option);
            AtomicBoolean inRequired = new AtomicBoolean(false);
            this.requiredOptions.forEach(requiredOption -> {
                if (requiredOption.getOptions().contains(option)) {
                    inRequired.set(true);
                }
            });
            if (!inOptions && !inRequired.get()) {
                throw new OptionValidationException(String.format("Conditional '%s' not found in options.", option.key()));
            }
        }
    }
}

