/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ConfigUtil {
    private static final JavaPropsMapper PROPERTIES_MAPPER = new JavaPropsMapper();
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();

    public static Map<String, Object> treeMap(Object rawMap) {
        try {
            return PROPERTIES_MAPPER.readValue(PROPERTIES_MAPPER.writeValueAsString(rawMap), new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Json parsing exception.");
        }
    }

    static Object flatteningMap(Object rawValue, Map<String, Object> newMap, List<String> keys, boolean nestedMap) {
        if (rawValue == null) {
            return null;
        }
        if (!(rawValue instanceof List) && !(rawValue instanceof Map)) {
            if (newMap == null) {
                return rawValue;
            }
            newMap.put(String.join((CharSequence)".", keys), rawValue);
            return newMap;
        }
        if (rawValue instanceof List) {
            List rawList = (List)rawValue;
            rawList.replaceAll(value -> ConfigUtil.flatteningMap(value, null, null, false));
            if (newMap != null) {
                newMap.put(String.join((CharSequence)".", keys), rawList);
                return newMap;
            }
            return rawList;
        }
        Map rawMap = (Map)rawValue;
        if (!nestedMap) {
            keys = new ArrayList<String>();
            newMap = new HashMap<String, Object>(rawMap.size());
        }
        for (Map.Entry entry : rawMap.entrySet()) {
            keys.add((String)entry.getKey());
            ConfigUtil.flatteningMap(entry.getValue(), newMap, keys, true);
            keys.remove(keys.size() - 1);
        }
        return newMap;
    }

    public static Map<String, Object> flatteningMap(Map<String, Object> treeMap) {
        return (Map)ConfigUtil.flatteningMapWithObject(treeMap);
    }

    static Object flatteningMapWithObject(Object rawValue) {
        return ConfigUtil.flatteningMap(rawValue, null, null, false);
    }

    public static <T> T convertValue(Object rawValue, TypeReference<T> typeReference) {
        rawValue = ConfigUtil.flatteningMapWithObject(rawValue);
        if (typeReference.getType() instanceof Class) {
            Class clazz = (Class)typeReference.getType();
            if (clazz.equals(rawValue.getClass())) {
                return (T)rawValue;
            }
            try {
                return ConfigUtil.convertValue(rawValue, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            return JACKSON_MAPPER.readValue(ConfigUtil.convertToJsonString(rawValue), typeReference);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Json parsing exception, value '%s', and expected type '%s'", rawValue, typeReference.getType().getTypeName()), e);
        }
    }

    static <T> T convertValue(Object rawValue, Class<T> clazz) {
        if (Boolean.class.equals(clazz)) {
            return (T)ConfigUtil.convertToBoolean(rawValue);
        }
        if (clazz.isEnum()) {
            return ConfigUtil.convertToEnum(rawValue, clazz);
        }
        if (String.class.equals(clazz)) {
            return (T)ConfigUtil.convertToJsonString(rawValue);
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    static Boolean convertToBoolean(Object o) {
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    static <E extends Enum<?>> E convertToEnum(Object o, Class<E> clazz) {
        return (E)Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    public static String convertToJsonString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        try {
            return JACKSON_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Could not parse json, value: %s", o));
        }
    }
}

