/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.ConfigUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigRenderOptions;

public class ReadonlyConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();
    protected final Map<String, Object> confData;

    private ReadonlyConfig(Map<String, Object> confData) {
        this.confData = confData;
    }

    public static ReadonlyConfig fromMap(Map<String, Object> map2) {
        return new ReadonlyConfig(ConfigUtil.treeMap(map2));
    }

    public static ReadonlyConfig fromConfig(Config config) {
        try {
            return ReadonlyConfig.fromMap(JACKSON_MAPPER.readValue(config.root().render(ConfigRenderOptions.concise()), new TypeReference<Map<String, Object>>(){}));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Json parsing exception.", e);
        }
    }

    public <T> T get(Option<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    public Map<String, String> toMap() {
        if (this.confData.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        this.toMap(result2);
        return result2;
    }

    public void toMap(Map<String, String> result2) {
        if (this.confData.isEmpty()) {
            return;
        }
        Map<String, Object> flatteningMap = ConfigUtil.flatteningMap(this.confData);
        for (Map.Entry<String, Object> entry : flatteningMap.entrySet()) {
            result2.put(entry.getKey(), ConfigUtil.convertToJsonString(entry.getValue()));
        }
    }

    public <T> Optional<T> getOptional(Option<T> option) {
        if (option == null) {
            throw new NullPointerException("Option not be null.");
        }
        String[] keys = option.key().split("\\.");
        Map data = this.confData;
        Object value = null;
        for (int i = 0; i < keys.length; ++i) {
            value = data.get(keys[i]);
            if (i >= keys.length - 1) continue;
            if (!(value instanceof Map)) {
                return Optional.empty();
            }
            data = (Map)value;
        }
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(ConfigUtil.convertValue(value, option.typeReference()));
    }

    public int hashCode() {
        int hash = 0;
        for (String s2 : this.confData.keySet()) {
            hash ^= s2.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReadonlyConfig)) {
            return false;
        }
        Map<String, Object> otherConf = ((ReadonlyConfig)obj).confData;
        return this.confData.equals(otherConf);
    }

    public String toString() {
        return ConfigUtil.convertToJsonString(this.confData);
    }
}

