/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.TokenFilter;

public class JsonPointerBasedFilter
extends TokenFilter {
    protected final JsonPointer _pathToMatch;

    public JsonPointerBasedFilter(String ptrExpr) {
        this(JsonPointer.compile(ptrExpr));
    }

    public JsonPointerBasedFilter(JsonPointer match) {
        this._pathToMatch = match;
    }

    @Override
    public TokenFilter includeElement(int index) {
        JsonPointer next2 = this._pathToMatch.matchElement(index);
        if (next2 == null) {
            return null;
        }
        if (next2.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new JsonPointerBasedFilter(next2);
    }

    @Override
    public TokenFilter includeProperty(String name) {
        JsonPointer next2 = this._pathToMatch.matchProperty(name);
        if (next2 == null) {
            return null;
        }
        if (next2.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new JsonPointerBasedFilter(next2);
    }

    @Override
    public TokenFilter filterStartArray() {
        return this;
    }

    @Override
    public TokenFilter filterStartObject() {
        return this;
    }

    @Override
    protected boolean _includeScalar() {
        return this._pathToMatch.matches();
    }

    @Override
    public String toString() {
        return "[JsonPointerFilter at: " + this._pathToMatch + "]";
    }
}

