/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.split.JdbcParameterValuesProvider;

public class JdbcNumericBetweenParametersProvider
implements JdbcParameterValuesProvider {
    private final long minVal;
    private final long maxVal;
    private long batchSize;
    private int batchNum;

    public JdbcNumericBetweenParametersProvider(long minVal, long maxVal) {
        Preconditions.checkArgument((minVal <= maxVal ? 1 : 0) != 0, (Object)"minVal must not be larger than maxVal");
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public JdbcNumericBetweenParametersProvider(long fetchSize, long minVal, long maxVal) {
        Preconditions.checkArgument((minVal <= maxVal ? 1 : 0) != 0, (Object)"minVal must not be larger than maxVal");
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.ofBatchSize(fetchSize);
    }

    public JdbcNumericBetweenParametersProvider ofBatchSize(long batchSize) {
        Preconditions.checkArgument((batchSize > 0L ? 1 : 0) != 0, (Object)"Batch size must be positive");
        long maxElemCount = this.maxVal - this.minVal + 1L;
        if (batchSize > maxElemCount) {
            batchSize = maxElemCount;
        }
        this.batchSize = batchSize;
        this.batchNum = new Double(Math.ceil((double)maxElemCount / (double)batchSize)).intValue();
        return this;
    }

    public JdbcNumericBetweenParametersProvider ofBatchNum(int batchNum) {
        Preconditions.checkArgument((batchNum > 0 ? 1 : 0) != 0, (Object)"Batch number must be positive");
        long maxElemCount = this.maxVal - this.minVal + 1L;
        if ((long)batchNum > maxElemCount) {
            batchNum = (int)maxElemCount;
        }
        this.batchNum = batchNum;
        this.batchSize = new Double(Math.ceil((double)maxElemCount / (double)batchNum)).longValue();
        return this;
    }

    @Override
    public Serializable[][] getParameterValues() {
        Preconditions.checkState((this.batchSize > 0L ? 1 : 0) != 0, (Object)"Batch size and batch number must be positive. Have you called `ofBatchSize` or `ofBatchNum`?");
        long maxElemCount = this.maxVal - this.minVal + 1L;
        long bigBatchNum = maxElemCount - (this.batchSize - 1L) * (long)this.batchNum;
        Serializable[][] parameters = new Serializable[this.batchNum][2];
        long start = this.minVal;
        for (int i = 0; i < this.batchNum; ++i) {
            long end = start + this.batchSize - 1L - (long)((long)i >= bigBatchNum ? 1 : 0);
            parameters[i] = new Long[]{start, end};
            start = end + 1L;
        }
        return parameters;
    }
}

