/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.sqlserver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;

public class SqlServerURLParser {
    private static final int DEFAULT_PORT = 1433;

    public static JdbcUrlUtil.UrlInfo parse(String url) {
        int instanceLoc;
        int portLoc;
        String urlServerName;
        String serverName = "";
        Integer port = 1433;
        String dbInstance = null;
        int hostIndex = url.indexOf("://");
        if (hostIndex <= 0) {
            return null;
        }
        Map<Object, Object> props = Collections.emptyMap();
        String[] split = url.split(";", 2);
        if (split.length > 1) {
            props = SqlServerURLParser.parseQueryParams(split[1], ";");
            serverName = (String)props.get("serverName");
            dbInstance = (String)props.getOrDefault("databaseName", props.get("database"));
            if (props.containsKey("portNumber")) {
                String portNumber = (String)props.get("portNumber");
                try {
                    port = Integer.parseInt(portNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!(urlServerName = split[0].substring(hostIndex + 3)).isEmpty()) {
            serverName = urlServerName;
        }
        if ((portLoc = serverName.indexOf(":")) > 1) {
            port = Integer.parseInt(serverName.substring(portLoc + 1));
            serverName = serverName.substring(0, portLoc);
        }
        if ((instanceLoc = serverName.indexOf("\\")) > 1) {
            serverName = serverName.substring(0, instanceLoc);
        }
        if (serverName.isEmpty()) {
            return null;
        }
        String suffix = props.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";", ";", ""));
        suffix = Optional.ofNullable(suffix).orElse("");
        return new JdbcUrlUtil.UrlInfo(url, String.format("jdbc:sqlserver://%s:%s", serverName, port) + suffix, serverName, port, dbInstance, suffix);
    }

    private static Map<String, String> parseQueryParams(String query, String separator) {
        String[] pairs;
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        for (String pair : pairs = query.split(separator)) {
            try {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()) : pair;
                if (queryParams.containsKey(key)) continue;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()) : null;
                queryParams.put(key, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return queryParams;
    }
}

