/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mysql.cj.MysqlType;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;

@AutoService(value={DataTypeConvertor.class})
public class MysqlDataTypeConvertor
implements DataTypeConvertor<MysqlType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;

    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType) {
        ImmutableMap dataTypeProperties;
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"connectorDataType can not be null");
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        switch (mysqlType) {
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: 
            case BIT: {
                int left = connectorDataType.indexOf("(");
                int right = connectorDataType.indexOf(")");
                int precision = DEFAULT_PRECISION;
                int scale = DEFAULT_SCALE;
                if (left != -1 && right != -1) {
                    String[] precisionAndScale = connectorDataType.substring(left + 1, right).split(",");
                    if (precisionAndScale.length == 2) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                        scale = Integer.parseInt(precisionAndScale[1]);
                    } else if (precisionAndScale.length == 1) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                    }
                }
                dataTypeProperties = ImmutableMap.of((Object)PRECISION, (Object)precision, (Object)SCALE, (Object)scale);
                break;
            }
            default: {
                dataTypeProperties = Collections.emptyMap();
            }
        }
        return this.toSeaTunnelType(mysqlType, (Map<String, Object>)dataTypeProperties);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(MysqlType mysqlType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        Preconditions.checkNotNull((Object)mysqlType, (Object)"mysqlType can not be null");
        switch (mysqlType) {
            case NULL: {
                return BasicType.VOID_TYPE;
            }
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case BIT: {
                int precision = (Integer)dataTypeProperties.get(PRECISION);
                if (precision == 1) {
                    return BasicType.BOOLEAN_TYPE;
                }
                return PrimitiveByteArrayType.INSTANCE;
            }
            case TINYINT: {
                return BasicType.BYTE_TYPE;
            }
            case TINYINT_UNSIGNED: 
            case SMALLINT: {
                return BasicType.SHORT_TYPE;
            }
            case SMALLINT_UNSIGNED: 
            case INT: 
            case MEDIUMINT: 
            case MEDIUMINT_UNSIGNED: 
            case YEAR: {
                return BasicType.INT_TYPE;
            }
            case INT_UNSIGNED: 
            case BIGINT: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: 
            case FLOAT_UNSIGNED: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: 
            case DOUBLE_UNSIGNED: {
                return BasicType.DOUBLE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case JSON: 
            case ENUM: {
                return BasicType.STRING_TYPE;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case GEOMETRY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: {
                int precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                int scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                return new DecimalType(precision, scale);
            }
        }
        throw DataTypeConvertException.convertToSeaTunnelDataTypeException((Object)mysqlType);
    }

    public MysqlType toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case ARRAY: 
            case MAP: 
            case ROW: 
            case STRING: {
                return MysqlType.VARCHAR;
            }
            case BOOLEAN: {
                return MysqlType.BOOLEAN;
            }
            case TINYINT: {
                return MysqlType.TINYINT;
            }
            case SMALLINT: {
                return MysqlType.SMALLINT;
            }
            case INT: {
                return MysqlType.INT;
            }
            case BIGINT: {
                return MysqlType.BIGINT;
            }
            case FLOAT: {
                return MysqlType.FLOAT;
            }
            case DOUBLE: {
                return MysqlType.DOUBLE;
            }
            case DECIMAL: {
                return MysqlType.DECIMAL;
            }
            case NULL: {
                return MysqlType.NULL;
            }
            case BYTES: {
                return MysqlType.BIT;
            }
            case DATE: {
                return MysqlType.DATE;
            }
            case TIME: {
                return MysqlType.DATETIME;
            }
            case TIMESTAMP: {
                return MysqlType.TIMESTAMP;
            }
        }
        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_DATA_TYPE, String.format("Doesn't support MySQL type '%s' yet", sqlType));
    }

    public String getIdentity() {
        return "Mysql";
    }
}

