/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;

public class MysqlCreateTableSqlBuilder {
    private final String tableName;
    private List<Column> columns;
    private String comment;
    private String engine;
    private String charset;
    private String collate;
    private PrimaryKey primaryKey;
    private List<ConstraintKey> constraintKeys;
    private MysqlDataTypeConvertor mysqlDataTypeConvertor;

    private MysqlCreateTableSqlBuilder(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName must not be null");
        this.tableName = tableName;
        this.mysqlDataTypeConvertor = new MysqlDataTypeConvertor();
    }

    public static MysqlCreateTableSqlBuilder builder(TablePath tablePath, CatalogTable catalogTable) {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath must not be null");
        Preconditions.checkNotNull((Object)catalogTable, (Object)"catalogTable must not be null");
        TableSchema tableSchema = catalogTable.getTableSchema();
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema must not be null");
        return new MysqlCreateTableSqlBuilder(tablePath.getTableName()).comment(catalogTable.getComment()).engine(null).charset(null).primaryKey(tableSchema.getPrimaryKey()).constraintKeys(tableSchema.getConstraintKeys()).addColumn(tableSchema.getColumns());
    }

    public MysqlCreateTableSqlBuilder addColumn(List<Column> columns) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columns), (Object)"columns must not be empty");
        this.columns = columns;
        return this;
    }

    public MysqlCreateTableSqlBuilder primaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public MysqlCreateTableSqlBuilder constraintKeys(List<ConstraintKey> constraintKeys) {
        this.constraintKeys = constraintKeys;
        return this;
    }

    public MysqlCreateTableSqlBuilder engine(String engine) {
        this.engine = engine;
        return this;
    }

    public MysqlCreateTableSqlBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public MysqlCreateTableSqlBuilder collate(String collate) {
        this.collate = collate;
        return this;
    }

    public MysqlCreateTableSqlBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String build() {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(String.format("CREATE TABLE IF NOT EXISTS %s (\n%s\n)", this.tableName, this.buildColumnsIdentifySql()));
        if (this.engine != null) {
            sqls.add("ENGINE = " + this.engine);
        }
        if (this.charset != null) {
            sqls.add("DEFAULT CHARSET = " + this.charset);
        }
        if (this.collate != null) {
            sqls.add("COLLATE = " + this.collate);
        }
        if (this.comment != null) {
            sqls.add("COMMENT = '" + this.comment + "'");
        }
        return String.join((CharSequence)" ", sqls) + ";";
    }

    private String buildColumnsIdentifySql() {
        ArrayList<String> columnSqls = new ArrayList<String>();
        for (Column column : this.columns) {
            columnSqls.add("\t" + this.buildColumnIdentifySql(column));
        }
        if (this.primaryKey != null) {
            columnSqls.add("\t" + this.buildPrimaryKeySql());
        }
        if (CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (StringUtils.isBlank((CharSequence)constraintKey.getConstraintName())) continue;
                columnSqls.add("\t" + this.buildConstraintKeySql(constraintKey));
            }
        }
        return String.join((CharSequence)", \n", columnSqls);
    }

    private String buildColumnIdentifySql(Column column) {
        ArrayList<String> columnSqls = new ArrayList<String>();
        columnSqls.add(column.getName());
        columnSqls.add(this.mysqlDataTypeConvertor.toConnectorType(column.getDataType(), null).getName());
        if (column.getColumnLength() != null) {
            columnSqls.add("(" + column.getColumnLength() + ")");
        }
        if (column.isNullable()) {
            columnSqls.add("NULL");
        } else {
            columnSqls.add("NOT NULL");
        }
        if (column.getDefaultValue() != null) {
            columnSqls.add("DEFAULT '" + column.getDefaultValue() + "'");
        }
        if (column.getComment() != null) {
            columnSqls.add("COMMENT '" + column.getComment() + "'");
        }
        return String.join((CharSequence)" ", columnSqls);
    }

    private String buildPrimaryKeySql() {
        String key = this.primaryKey.getColumnNames().stream().map(columnName -> "`" + columnName + "`").collect(Collectors.joining(", "));
        return String.format("PRIMARY KEY (%s)", key);
    }

    private String buildConstraintKeySql(ConstraintKey constraintKey) {
        ConstraintKey.ConstraintType constraintType = constraintKey.getConstraintType();
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> {
            if (constraintKeyColumn.getSortType() == null) {
                return String.format("`%s`", constraintKeyColumn.getColumnName());
            }
            return String.format("`%s` %s", constraintKeyColumn.getColumnName(), constraintKeyColumn.getSortType().name());
        }).collect(Collectors.joining(", "));
        String keyName = null;
        switch (constraintType) {
            case KEY: {
                keyName = "KEY";
                break;
            }
            case UNIQUE_KEY: {
                keyName = "UNIQUE KEY";
                break;
            }
            case FOREIGN_KEY: {
                keyName = "FOREIGN KEY";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported constraint type: " + constraintType);
            }
        }
        return String.format("%s `%s` (%s)", keyName, constraintKey.getConstraintName(), indexColumns);
    }
}

