/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.LinkedList;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de!\u0002\u001c8\u0005m\n\u0005\u0002C-\u0001\u0005\u000b\u0007I\u0011\u0001.\t\u0011y\u0003!\u0011!Q\u0001\nmCQa\u0018\u0001\u0005\u0002\u0001DQa\u0019\u0001\u0005\u0002iCQ\u0001\u001a\u0001\u0005\u0002\u0015DQ!\u001b\u0001\u0005\u0002\u0015DQA\u001b\u0001\u0005\u0002\u0015DQa\u001b\u0001\u0005\u00021DQA\u001d\u0001\u0005\u0002MDQ\u0001\u001e\u0001\u0005\u0002MDQ!\u001e\u0001\u0005\u0002YDQa\u001e\u0001\u0005\u0002YDQ\u0001\u001f\u0001\u0005\u0002YDq!\u001f\u0001A\u0002\u0013%!\u0010C\u0004|\u0001\u0001\u0007I\u0011\u0002?\t\r}\u0004\u0001\u0015)\u0003J\u000f!\tya\u000eE\u0001w\u0005Eaa\u0002\u001c8\u0011\u0003Y\u00141\u0003\u0005\u0007?J!\t!!\u0006\u0007\r\u0005]!CBA\r\u0011!IFC!b\u0001\n\u0003R\u0006\u0002\u00030\u0015\u0005\u0003\u0005\u000b\u0011B.\t\u0015\u0005\rBC!A!\u0002\u0013\t)\u0003\u0003\u0004`)\u0011\u0005\u00111\u0006\u0005\n\u0003k!\"\u0019!C\u0005\u0003oA\u0001\"a\u0010\u0015A\u0003%\u0011\u0011\b\u0005\t\u0003\u0003\"\u0002\u0019!C\u00055\"I\u00111\t\u000bA\u0002\u0013%\u0011Q\t\u0005\b\u0003\u0013\"\u0002\u0015)\u0003\\\u0011!\tY\u0005\u0006a\u0001\n\u0013Q\u0006\"CA')\u0001\u0007I\u0011BA(\u0011\u001d\t\u0019\u0006\u0006Q!\nmCQa\u0019\u000b\u0005BiCQ\u0001\u001a\u000b\u0005B\u0015DQ!\u001b\u000b\u0005B\u0015DQA\u001b\u000b\u0005B\u0015Daa\u001b\u000b\u0005B\u0005U\u0003B\u0002:\u0015\t\u0003\nI\u0006\u0003\u0004u)\u0011\u0005\u0013\u0011\f\u0005\u0006kR!\tE\u001e\u0005\u0006oR!\tE\u001e\u0005\u0006qR!\tE\u001e\u0004\u0007\u00037\u0012b!!\u0018\t\u0011e[#Q1A\u0005BiC\u0001BX\u0016\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0007?.\"\t!a\u001e\t\u000b\r\\C\u0011\t.\t\u000b\u0011\\C\u0011I3\t\u000b)\\C\u0011I3\t\r-\\C\u0011IA?\u0011\u0019\u00118\u0006\"\u0011\u0002\u0002\")qo\u000bC!m\")\u0001p\u000bC!m\ni!i\\;oI\u0016$')\u001e4gKJT!\u0001O\u001d\u0002\t%l\u0007\u000f\u001c\u0006\u0003um\naa\u001d;sK\u0006l'B\u0001\u001f>\u0003\u0015\u0001Xm[6p\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\u0016\u0005\t{5c\u0001\u0001D\u0013B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u00042AS&N\u001b\u00059\u0014B\u0001'8\u0005\u0019\u0011UO\u001a4feB\u0011aj\u0014\u0007\u0001\t\u0015\u0001\u0006A1\u0001S\u0005\u0005!6\u0001A\t\u0003'Z\u0003\"\u0001\u0012+\n\u0005U+%a\u0002(pi\"Lgn\u001a\t\u0003\t^K!\u0001W#\u0003\u0007\u0005s\u00170\u0001\u0005dCB\f7-\u001b;z+\u0005Y\u0006C\u0001#]\u0013\tiVIA\u0002J]R\f\u0011bY1qC\u000eLG/\u001f\u0011\u0002\rqJg.\u001b;?)\t\t'\rE\u0002K\u00015CQ!W\u0002A\u0002m\u000bA!^:fI\u00061\u0011n\u001d$vY2,\u0012A\u001a\t\u0003\t\u001eL!\u0001[#\u0003\u000f\t{w\u000e\\3b]\u00069\u0011n]#naRL\u0018\u0001\u00038p]\u0016k\u0007\u000f^=\u0002\u000f\u0015t\u0017/^3vKR\u0011Q\u000e\u001d\t\u0003\t:L!a\\#\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\"\u0001\r!T\u0001\u0005K2,W.A\u0004eKF,X-^3\u0015\u00035\u000bA\u0001]3fW\u0006)1\r\\3beR\tQ.\u0001\u0005ee>\u0004\b*Z1e\u0003!!'o\u001c9UC&d\u0017!A9\u0016\u0003%\u000bQ!]0%KF$\"!\\?\t\u000fy|\u0011\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\u0002\u0005E\u0004\u0003f\u0001\u0001\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nm\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0002\u0003\u0017%sG/\u001a:oC2\f\u0005/[\u0001\u000e\u0005>,h\u000eZ3e\u0005V4g-\u001a:\u0011\u0005)\u00132C\u0001\nD)\t\t\tB\u0001\u0006GSb,G-U;fk\u0016,B!a\u0007\u0002\"M!AcQA\u000f!\u0011Q5*a\b\u0011\u00079\u000b\t\u0003B\u0003Q)\t\u0007!+\u0001\u0007to&$8\r\u001b\"vM\u001a,'\u000f\u0005\u0004E\u0003O\ti\"\\\u0005\u0004\u0003S)%!\u0003$v]\u000e$\u0018n\u001c82)\u0019\ti#!\r\u00024A)\u0011q\u0006\u000b\u0002 5\t!\u0003C\u0003Z1\u0001\u00071\fC\u0004\u0002$a\u0001\r!!\n\u0002\u000bE,X-^3\u0016\u0005\u0005e\u0002\u0003\u0002#\u0002<\rK1!!\u0010F\u0005\u0015\t%O]1z\u0003\u0019\tX/Z;fA\u0005!\u0001.Z1e\u0003!AW-\u00193`I\u0015\fHcA7\u0002H!9a\u0010HA\u0001\u0002\u0004Y\u0016!\u00025fC\u0012\u0004\u0013\u0001\u0002;bS2\f\u0001\u0002^1jY~#S-\u001d\u000b\u0004[\u0006E\u0003b\u0002@ \u0003\u0003\u0005\raW\u0001\u0006i\u0006LG\u000e\t\u000b\u0004[\u0006]\u0003BB9&\u0001\u0004\ty\u0002\u0006\u0002\u0002 \taA)\u001f8b[&\u001c\u0017+^3vKV!\u0011qLA:'\u0015Y\u0013\u0011MA;!\u0019\t\u0019'!\u001c\u0002r5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003vi&d'BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014Q\r\u0002\u000b\u0019&t7.\u001a3MSN$\bc\u0001(\u0002t\u0011)\u0001k\u000bb\u0001%B!!jSA9)\u0011\tI(a\u001f\u0011\u000b\u0005=2&!\u001d\t\u000bes\u0003\u0019A.\u0015\u00075\fy\b\u0003\u0004re\u0001\u0007\u0011\u0011\u000f\u000b\u0003\u0003cB3AEA\u0002Q\r\t\u00121\u0001")
@InternalApi
public final class BoundedBuffer<T>
implements Buffer<T> {
    private final int capacity;
    private Buffer<T> q;

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int used() {
        return this.q().used();
    }

    @Override
    public boolean isFull() {
        return this.q().isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.q().isEmpty();
    }

    @Override
    public boolean nonEmpty() {
        return this.q().nonEmpty();
    }

    @Override
    public void enqueue(T elem) {
        this.q().enqueue(elem);
    }

    @Override
    public T dequeue() {
        return this.q().dequeue();
    }

    @Override
    public T peek() {
        return this.q().peek();
    }

    @Override
    public void clear() {
        this.q().clear();
    }

    @Override
    public void dropHead() {
        this.q().dropHead();
    }

    @Override
    public void dropTail() {
        this.q().dropTail();
    }

    private Buffer<T> q() {
        return this.q;
    }

    private void q_$eq(Buffer<T> x$1) {
        this.q = x$1;
    }

    public BoundedBuffer(int capacity) {
        this.capacity = capacity;
        this.q = new FixedQueue(capacity, (Function1 & Serializable)newBuffer -> {
            this.q_$eq(newBuffer);
            return BoxedUnit.UNIT;
        });
    }

    private static final class DynamicQueue<T>
    extends LinkedList<T>
    implements Buffer<T> {
        private final int capacity;

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public int used() {
            return this.size();
        }

        @Override
        public boolean isFull() {
            return this.size() == this.capacity();
        }

        @Override
        public boolean nonEmpty() {
            return !this.isEmpty();
        }

        @Override
        public void enqueue(T elem) {
            this.add(elem);
        }

        @Override
        public T dequeue() {
            return (T)this.remove();
        }

        @Override
        public void dropHead() {
            this.remove();
        }

        @Override
        public void dropTail() {
            this.removeLast();
        }

        public DynamicQueue(int capacity) {
            this.capacity = capacity;
        }
    }

    private static final class FixedQueue<T>
    implements Buffer<T> {
        private final int capacity;
        private final Function1<Buffer<T>, BoxedUnit> switchBuffer;
        private final Object[] queue;
        private int head;
        private int tail;

        @Override
        public int capacity() {
            return this.capacity;
        }

        private Object[] queue() {
            return this.queue;
        }

        private int head() {
            return this.head;
        }

        private void head_$eq(int x$1) {
            this.head = x$1;
        }

        private int tail() {
            return this.tail;
        }

        private void tail_$eq(int x$1) {
            this.tail = x$1;
        }

        @Override
        public int used() {
            return this.tail() - this.head();
        }

        @Override
        public boolean isFull() {
            return this.used() == this.capacity();
        }

        @Override
        public boolean isEmpty() {
            return this.tail() == this.head();
        }

        @Override
        public boolean nonEmpty() {
            return this.tail() != this.head();
        }

        @Override
        public void enqueue(T elem) {
            if (this.tail() - this.head() == Buffer$.MODULE$.FixedQueueSize()) {
                DynamicQueue<T> queue = new DynamicQueue<T>(this.capacity());
                while (this.nonEmpty()) {
                    queue.enqueue(this.dequeue());
                }
                this.switchBuffer.apply(queue);
                queue.enqueue(elem);
                return;
            }
            this.queue()[this.tail() & Buffer$.MODULE$.FixedQueueMask()] = elem;
            this.tail_$eq(this.tail() + 1);
        }

        @Override
        public T dequeue() {
            int pos = this.head() & Buffer$.MODULE$.FixedQueueMask();
            Object ret = this.queue()[pos];
            this.queue()[pos] = null;
            this.head_$eq(this.head() + 1);
            return (T)ret;
        }

        @Override
        public T peek() {
            if (this.tail() == this.head()) {
                return null;
            }
            return (T)this.queue()[this.head() & Buffer$.MODULE$.FixedQueueMask()];
        }

        @Override
        public void clear() {
            while (this.nonEmpty()) {
                this.dequeue();
            }
        }

        @Override
        public void dropHead() {
            this.dequeue();
        }

        @Override
        public void dropTail() {
            this.tail_$eq(this.tail() - 1);
            this.queue()[this.tail() & Buffer$.MODULE$.FixedQueueMask()] = null;
        }

        public FixedQueue(int capacity, Function1<Buffer<T>, BoxedUnit> switchBuffer) {
            this.capacity = capacity;
            this.switchBuffer = switchBuffer;
            this.queue = new Object[Buffer$.MODULE$.FixedQueueSize()];
            this.head = 0;
            this.tail = 0;
        }
    }
}

