/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.glob;

import org.apache.parquet.glob.WildcardPath;
import org.junit.Assert;
import org.junit.Test;

public class TestWildcardPath {
    private static void assertMatches(WildcardPath wp, String ... strings) {
        for (String s : strings) {
            if (wp.matches(s)) continue;
            Assert.fail((String)String.format("String '%s' was expected to match '%s'", s, wp));
        }
    }

    private static void assertDoesNotMatch(WildcardPath wp, String ... strings) {
        for (String s : strings) {
            if (!wp.matches(s)) continue;
            Assert.fail((String)String.format("String '%s' was not expected to match '%s'", s, wp));
        }
    }

    @Test
    public void testNoWildcards() {
        WildcardPath wp = new WildcardPath("", "foo", '.');
        TestWildcardPath.assertMatches(wp, "foo", "foo.x", "foo.x.y");
        TestWildcardPath.assertDoesNotMatch(wp, "xfoo", "xfoox", "fooa.x.y");
    }

    @Test
    public void testStarMatchesEverything() {
        WildcardPath wp = new WildcardPath("", "*", '.');
        TestWildcardPath.assertMatches(wp, "", ".", "hi", "foo.bar", "*", "foo.");
    }

    @Test
    public void testChildrenPathsMatch() {
        WildcardPath wp = new WildcardPath("", "x.y.z", '.');
        TestWildcardPath.assertMatches(wp, "x.y.z", "x.y.z.bar", "x.y.z.bar.baz.bop");
        TestWildcardPath.assertDoesNotMatch(wp, "x.y.zzzz", "x.y.b", "x.y.a.z", "x.y.zhi.z");
    }

    @Test
    public void testEmptyString() {
        WildcardPath wp = new WildcardPath("", "", '.');
        TestWildcardPath.assertMatches(wp, "");
        TestWildcardPath.assertDoesNotMatch(wp, "x");
    }

    @Test
    public void testDoubleStarsIgnored() {
        WildcardPath wp = new WildcardPath("", "foo**bar", '.');
        TestWildcardPath.assertMatches(wp, "foobar", "fooxyzbar", "foo.x.y.z.bar");
        TestWildcardPath.assertDoesNotMatch(wp, "fobar", "hi", "foobazr");
        wp = new WildcardPath("", "foo********bar", '.');
        TestWildcardPath.assertMatches(wp, "foobar", "fooxyzbar", "foo.x.y.z.bar");
        TestWildcardPath.assertDoesNotMatch(wp, "fobar", "hi", "foobazr");
    }

    @Test
    public void testStarsAtBeginAndEnd() {
        WildcardPath wp = new WildcardPath("", "*x.y.z", '.');
        TestWildcardPath.assertMatches(wp, "a.b.c.x.y.z", "x.y.z", "zoopx.y.z", "zoopx.y.z.child");
        TestWildcardPath.assertDoesNotMatch(wp, "a.b.c.x.y", "xy.z", "hi");
        wp = new WildcardPath("", "*.x.y.z", '.');
        TestWildcardPath.assertMatches(wp, "a.b.c.x.y.z", "foo.x.y.z", "foo.x.y.z.child");
        TestWildcardPath.assertDoesNotMatch(wp, "x.y.z", "a.b.c.x.y", "xy.z", "hi", "zoopx.y.z", "zoopx.y.z.child");
        wp = new WildcardPath("", "x.y.z*", '.');
        TestWildcardPath.assertMatches(wp, "x.y.z", "x.y.z.foo", "x.y.zoo", "x.y.zoo.bar");
        TestWildcardPath.assertDoesNotMatch(wp, "a.b.c.x.y.z", "foo.x.y.z", "hi");
        wp = new WildcardPath("", "x.y.z.*", '.');
        TestWildcardPath.assertMatches(wp, "x.y.z.foo", "x.y.z.bar.baz");
        TestWildcardPath.assertDoesNotMatch(wp, "x.y.z", "a.b.c.x.y.z", "x.y.zoo", "foo.x.y.z", "hi", "x.y.zoo.bar");
    }

    @Test
    public void testComplex() {
        WildcardPath wp = new WildcardPath("", "*.street", '.');
        TestWildcardPath.assertMatches(wp, "home.address.street", "home.address.street.number", "work.address.street", "work.address.street.foo", "street.street", "street.street.street.street", "thing.street.thing");
        TestWildcardPath.assertDoesNotMatch(wp, "home.address.street_2", "home.address.street_2.number", "work.addressstreet", "work.addressstreet.foo", "", "x.y.z.street2", "x.y.z.street2.z");
        wp = new WildcardPath("", "x.y.*_stat.average", '.');
        TestWildcardPath.assertMatches(wp, "x.y.z_stat.average", "x.y.foo_stat.average", "x.y.z.a.b_stat.average", "x.y.z.a.b_stat.average.child", "x.y.z._stat.average");
        TestWildcardPath.assertDoesNotMatch(wp, "x.y.z_stats.average", "x.y.z_stat.averages", "x.y_stat.average", "x.yyy.foo_stat.average");
        wp = new WildcardPath("", "x.y.pre*.bar", '.');
        TestWildcardPath.assertMatches(wp, "x.y.pre.bar", "x.y.preabc.bar", "x.y.prebar.bar");
        TestWildcardPath.assertDoesNotMatch(wp, "x.y.pre.baraaaa", "x.y.preabc.baraaaa");
    }
}

