/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.model.BaseModel;

public class DownloadUtil {
    private static final String baseUrl = "https://dlcdn.apache.org/opennlp/";
    public static Map<String, Map<ModelType, String>> available_models = new HashMap<String, Map<ModelType, String>>();

    public static BaseModel downloadModel(String language, ModelType modelType, Class type) throws IOException {
        String url;
        if (available_models.containsKey(language) && (url = available_models.get(language).get((Object)modelType)) != null) {
            return DownloadUtil.downloadModel(new URL(url), type);
        }
        throw new IOException("Invalid model.");
    }

    public static BaseModel downloadModel(URL url, Class type) throws IOException {
        Path homeDirectory = Paths.get(System.getProperty("user.home") + "/.opennlp/", new String[0]);
        if (!Files.isDirectory(homeDirectory, new LinkOption[0])) {
            homeDirectory.toFile().mkdir();
        }
        String filename = url.toString().substring(url.toString().lastIndexOf("/") + 1);
        Path localFile = Paths.get(homeDirectory.toString(), filename);
        if (!Files.exists(localFile, new LinkOption[0])) {
            System.out.println("Downloading model " + url + " to " + localFile);
            try (InputStream in = url.openStream();){
                Files.copy(in, localFile, StandardCopyOption.REPLACE_EXISTING);
            }
            System.out.println("Download complete.");
        }
        if (type == TokenizerModel.class) {
            return new TokenizerModel(localFile);
        }
        if (type == ChunkerModel.class) {
            return new ChunkerModel(localFile);
        }
        if (type == SentenceModel.class) {
            return new SentenceModel(localFile);
        }
        if (type == POSModel.class) {
            return new POSModel(localFile);
        }
        return new TokenNameFinderModel(localFile);
    }

    static {
        HashMap<ModelType, String> frenchModels = new HashMap<ModelType, String>();
        frenchModels.put(ModelType.SENTENCE_DETECTOR, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-1.0-1.9.3fr-ud-ftb-sentence-1.0-1.9.3.bin");
        frenchModels.put(ModelType.POS, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-fr-ud-ftb-pos-1.0-1.9.3.bin");
        frenchModels.put(ModelType.TOKENIZER, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-en-ud-ewt-tokens-1.0-1.9.3.bin");
        available_models.put("fr", frenchModels);
        HashMap<ModelType, String> germanModels = new HashMap<ModelType, String>();
        germanModels.put(ModelType.SENTENCE_DETECTOR, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-de-ud-gsd-sentence-1.0-1.9.3.bin");
        germanModels.put(ModelType.POS, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-de-ud-gsd-pos-1.0-1.9.3.bin");
        germanModels.put(ModelType.TOKENIZER, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-de-ud-gsd-tokens-1.0-1.9.3.bin");
        available_models.put("de", germanModels);
        HashMap<ModelType, String> englishModels = new HashMap<ModelType, String>();
        englishModels.put(ModelType.SENTENCE_DETECTOR, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-en-ud-ewt-sentence-1.0-1.9.3.bin");
        englishModels.put(ModelType.POS, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-en-ud-ewt-pos-1.0-1.9.3.bin");
        englishModels.put(ModelType.TOKENIZER, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-en-ud-ewt-tokens-1.0-1.9.3.bin");
        available_models.put("en", englishModels);
        HashMap<ModelType, String> italianModels = new HashMap<ModelType, String>();
        italianModels.put(ModelType.SENTENCE_DETECTOR, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-it-ud-vit-sentence-1.0-1.9.3.bin");
        italianModels.put(ModelType.POS, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-it-ud-vit-pos-1.0-1.9.3.bin");
        italianModels.put(ModelType.TOKENIZER, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-it-ud-vit-sentence-1.0-1.9.3.bin");
        available_models.put("it", italianModels);
        HashMap<ModelType, String> dutchModels = new HashMap<ModelType, String>();
        dutchModels.put(ModelType.SENTENCE_DETECTOR, "https://dlcdn.apache.org/opennlp/models/opennlp-nl-ud-alpino-sentence-1.0-1.9.3.bin");
        dutchModels.put(ModelType.POS, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-nl-ud-alpino-pos-1.0-1.9.3.bin");
        dutchModels.put(ModelType.TOKENIZER, "https://dlcdn.apache.org/opennlp/models/ud-models-1.0/opennlp-nl-ud-alpino-tokens-1.0-1.9.3.bin");
        available_models.put("nl", dutchModels);
    }

    public static enum ModelType {
        TOKENIZER("token"),
        SENTENCE_DETECTOR("sent"),
        POS("pos-perceptron"),
        NAME_FINDER("ner"),
        CHUNKER("chunker"),
        PARSER("parser-chunking");

        private String name;

        private ModelType(String name) {
            this.name = name;
        }
    }
}

