/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.omid.metrics.CodahaleMetricsConfig;
import org.apache.omid.metrics.Counter;
import org.apache.omid.metrics.Gauge;
import org.apache.omid.metrics.Histogram;
import org.apache.omid.metrics.Meter;
import org.apache.omid.metrics.MetricsProvider;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.Timer;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.net.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodahaleMetricsProvider
implements MetricsProvider,
MetricsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CodahaleMetricsProvider.class);
    private MetricRegistry metrics = new MetricRegistry();
    private List<ScheduledReporter> reporters = new ArrayList<ScheduledReporter>();
    private final int metricsOutputFrequencyInSecs;

    public CodahaleMetricsProvider(CodahaleMetricsConfig conf) throws IOException {
        this.metricsOutputFrequencyInSecs = conf.getOutputFreqInSecs();
        int reporterCount = 0;
        for (CodahaleMetricsConfig.Reporter reporter : conf.getReporters()) {
            ScheduledReporter codahaleReporter = null;
            switch (reporter) {
                case CONSOLE: {
                    codahaleReporter = this.createAndGetConfiguredConsoleReporter();
                    break;
                }
                case GRAPHITE: {
                    codahaleReporter = this.createAndGetConfiguredGraphiteReporter(conf.getPrefix(), conf.getGraphiteHostConfig());
                    break;
                }
                case CSV: {
                    codahaleReporter = this.createAndGetConfiguredCSVReporter(conf.getPrefix(), conf.getCsvDir());
                    break;
                }
                case SLF4J: {
                    codahaleReporter = this.createAndGetConfiguredSlf4jReporter(conf.getSlf4jLogger());
                }
            }
            if (codahaleReporter == null) continue;
            this.reporters.add(codahaleReporter);
            ++reporterCount;
        }
        if (reporterCount == 0) {
            LOG.warn("No metric reporters found, so metrics won't be available");
        }
        this.startMetrics();
    }

    public void startMetrics() {
        for (ScheduledReporter r : this.reporters) {
            LOG.info("Starting metrics reporter {} reporting every {} Secs", (Object)r.getClass().getCanonicalName(), (Object)this.metricsOutputFrequencyInSecs);
            r.start((long)this.metricsOutputFrequencyInSecs, TimeUnit.SECONDS);
        }
    }

    public void stopMetrics() {
        for (ScheduledReporter r : this.reporters) {
            r.report();
            LOG.info("Stopping reporter {}", (Object)r.toString());
            r.stop();
        }
    }

    public <T extends Number> void gauge(String name, Gauge<T> appGauge) {
        this.metrics.register(name, new CodahaleGauge<T>(appGauge));
    }

    public Counter counter(String name) {
        com.codahale.metrics.Counter counter = this.metrics.counter(name);
        return new CodahaleCounterWrapper(counter);
    }

    public Timer timer(String name) {
        com.codahale.metrics.Timer timer = this.metrics.timer(name);
        return new CodahaleTimerWrapper(timer);
    }

    public Meter meter(String name) {
        com.codahale.metrics.Meter meter = this.metrics.meter(name);
        return new CodahaleMeterWrapper(meter);
    }

    public Histogram histogram(String name) {
        com.codahale.metrics.Histogram histogram = this.metrics.histogram(name);
        return new CodahaleHistogramWrapper(histogram);
    }

    private ScheduledReporter createAndGetConfiguredConsoleReporter() {
        return ConsoleReporter.forRegistry((MetricRegistry)this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
    }

    private ScheduledReporter createAndGetConfiguredGraphiteReporter(String prefix, String graphiteHost) {
        LOG.info("Configuring Graphite reporter. Sendig data to host:port {}", (Object)graphiteHost);
        HostAndPort addr = HostAndPort.fromString((String)graphiteHost);
        Graphite graphite = new Graphite(new InetSocketAddress(addr.getHost(), addr.getPort()));
        return GraphiteReporter.forRegistry((MetricRegistry)this.metrics).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
    }

    private ScheduledReporter createAndGetConfiguredCSVReporter(String prefix, String csvDir) throws IOException {
        File outputDir = Strings.isNullOrEmpty((String)prefix) ? new File(csvDir, prefix) : new File(csvDir);
        FileUtils.forceMkdir((File)outputDir);
        LOG.info("Configuring stats with csv output to directory [{}]", (Object)outputDir.getAbsolutePath());
        return CsvReporter.forRegistry((MetricRegistry)this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(outputDir);
    }

    private ScheduledReporter createAndGetConfiguredSlf4jReporter(String slf4jLogger) {
        LOG.info("Configuring stats with SLF4J with logger {}", (Object)slf4jLogger);
        return Slf4jReporter.forRegistry((MetricRegistry)this.metrics).outputTo(LoggerFactory.getLogger((String)slf4jLogger)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
    }

    private static class CodahaleHistogramWrapper
    implements Histogram {
        private com.codahale.metrics.Histogram histogram;

        CodahaleHistogramWrapper(com.codahale.metrics.Histogram histogram) {
            this.histogram = histogram;
        }

        public void update(int value) {
            this.histogram.update(value);
        }

        public void update(long value) {
            this.histogram.update(value);
        }
    }

    private static class CodahaleMeterWrapper
    implements Meter {
        private com.codahale.metrics.Meter meter;

        CodahaleMeterWrapper(com.codahale.metrics.Meter meter) {
            this.meter = meter;
        }

        public void mark() {
            this.meter.mark();
        }

        public void mark(long n) {
            this.meter.mark(n);
        }
    }

    private static class CodahaleTimerWrapper
    implements Timer {
        private final com.codahale.metrics.Timer timer;
        private Timer.Context context;

        CodahaleTimerWrapper(com.codahale.metrics.Timer timer) {
            this.timer = timer;
        }

        public void start() {
            this.context = this.timer.time();
        }

        public void stop() {
            this.context.stop();
        }

        public void update(long durationInNs) {
            this.timer.update(durationInNs, TimeUnit.NANOSECONDS);
        }
    }

    private static class CodahaleCounterWrapper
    implements Counter {
        private final com.codahale.metrics.Counter counter;

        CodahaleCounterWrapper(com.codahale.metrics.Counter counter) {
            this.counter = counter;
        }

        public void inc() {
            this.counter.inc();
        }

        public void inc(long n) {
            this.counter.inc(n);
        }

        public void dec() {
            this.counter.dec();
        }

        public void dec(long n) {
            this.counter.dec(n);
        }
    }

    private static class CodahaleGauge<T extends Number>
    implements com.codahale.metrics.Gauge<T> {
        private final Gauge<T> omidGauge;

        CodahaleGauge(Gauge<T> omidGauge) {
            this.omidGauge = omidGauge;
        }

        public T getValue() {
            return (T)this.omidGauge.getValue();
        }
    }
}

