/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

public final class RepositoryPolicy {
    public static final String UPDATE_POLICY_NEVER = "never";
    public static final String UPDATE_POLICY_ALWAYS = "always";
    public static final String UPDATE_POLICY_DAILY = "daily";
    public static final String UPDATE_POLICY_INTERVAL = "interval";
    public static final String CHECKSUM_POLICY_FAIL = "fail";
    public static final String CHECKSUM_POLICY_WARN = "warn";
    public static final String CHECKSUM_POLICY_IGNORE = "ignore";
    private final boolean enabled;
    private final String artifactUpdatePolicy;
    private final String metadataUpdatePolicy;
    private final String checksumPolicy;

    public RepositoryPolicy() {
        this(true, UPDATE_POLICY_DAILY, UPDATE_POLICY_DAILY, CHECKSUM_POLICY_WARN);
    }

    public RepositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        this(enabled, updatePolicy, updatePolicy, checksumPolicy);
    }

    public RepositoryPolicy(boolean enabled, String artifactUpdatePolicy, String metadataUpdatePolicy, String checksumPolicy) {
        this.enabled = enabled;
        this.artifactUpdatePolicy = artifactUpdatePolicy != null ? artifactUpdatePolicy : "";
        this.metadataUpdatePolicy = metadataUpdatePolicy != null ? metadataUpdatePolicy : "";
        this.checksumPolicy = checksumPolicy != null ? checksumPolicy : "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public String getUpdatePolicy() {
        return this.getArtifactUpdatePolicy();
    }

    public String getArtifactUpdatePolicy() {
        return this.artifactUpdatePolicy;
    }

    public String getMetadataUpdatePolicy() {
        return this.metadataUpdatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String toString() {
        return "enabled=" + this.isEnabled() + ", checksums=" + this.getChecksumPolicy() + ", artifactUpdates=" + this.getArtifactUpdatePolicy() + ", metadataUpdates=" + this.getMetadataUpdatePolicy();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RepositoryPolicy that = (RepositoryPolicy)obj;
        return this.enabled == that.enabled && this.artifactUpdatePolicy.equals(that.artifactUpdatePolicy) && this.metadataUpdatePolicy.equals(that.metadataUpdatePolicy) && this.checksumPolicy.equals(that.checksumPolicy);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.enabled ? 1 : 0);
        hash = hash * 31 + this.artifactUpdatePolicy.hashCode();
        hash = hash * 31 + this.metadataUpdatePolicy.hashCode();
        hash = hash * 31 + this.checksumPolicy.hashCode();
        return hash;
    }
}

