/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.policy.semver;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.policy.version.VersionPolicyResult;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.eclipse.sisu.Description;
import org.semver.Version;

@Singleton
@Named(value="SemVerVersionPolicy")
@Description(value="A VersionPolicy following the SemVer rules")
public class SemVerVersionPolicy
implements VersionPolicy {
    public VersionPolicyResult getReleaseVersion(VersionPolicyRequest request) throws VersionParseException {
        Version version;
        try {
            version = Version.parse((String)request.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new VersionParseException(e.getMessage());
        }
        VersionPolicyResult result = new VersionPolicyResult();
        result.setVersion(version.toReleaseVersion().toString());
        return result;
    }

    public VersionPolicyResult getDevelopmentVersion(VersionPolicyRequest request) throws VersionParseException {
        Version version;
        try {
            version = Version.parse((String)request.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new VersionParseException(e.getMessage());
        }
        version = version.next(Version.Element.MINOR);
        VersionPolicyResult result = new VersionPolicyResult();
        result.setVersion(version + "-SNAPSHOT");
        return result;
    }
}

