/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.release.AbstractScmReadReleaseMojo;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.shared.release.DefaultReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleasePerformRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="perform", aggregator=true, requiresProject=false)
public class PerformReleaseMojo
extends AbstractScmReadReleaseMojo {
    @Parameter(property="goals")
    String goals;
    @Parameter(property="releaseProfiles")
    private String releaseProfiles;
    @Parameter(defaultValue="${project.build.directory}/checkout", property="workingDirectory", required=true)
    private File workingDirectory;
    @Parameter(property="connectionUrl")
    private String connectionUrl;
    @Parameter(defaultValue="false", property="localCheckout")
    private boolean localCheckout;
    @Deprecated
    @Parameter(defaultValue="false", property="useReleaseProfile")
    private boolean useReleaseProfile;
    @Parameter(defaultValue="false", property="dryRun")
    private boolean dryRun;

    @Inject
    public PerformReleaseMojo(ReleaseManager releaseManager, ScmManager scmManager) {
        super(releaseManager, scmManager);
    }

    @Override
    protected String getAdditionalProfiles() {
        return this.releaseProfiles;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.goals != null) {
            this.goals = StringUtils.join((Object[])this.goals.split("\\s+"), (String)" ");
        }
        try {
            this.setDeploymentRepository();
            ReleaseDescriptorBuilder releaseDescriptor = this.createReleaseDescriptor();
            if (this.connectionUrl != null) {
                releaseDescriptor.setScmSourceUrl(this.connectionUrl);
            }
            releaseDescriptor.setLocalCheckout(this.localCheckout);
            releaseDescriptor.setCheckoutDirectory(this.workingDirectory.getAbsolutePath());
            releaseDescriptor.setUseReleaseProfile(this.useReleaseProfile);
            this.createGoals();
            releaseDescriptor.setPerformGoals(this.goals);
            ReleasePerformRequest performRequest = new ReleasePerformRequest();
            performRequest.setReleaseDescriptorBuilder(releaseDescriptor);
            performRequest.setReleaseEnvironment(this.getReleaseEnvironment());
            performRequest.setReactorProjects(this.getReactorProjects());
            performRequest.setReleaseManagerListener((ReleaseManagerListener)new DefaultReleaseManagerListener(this.getLog(), this.dryRun));
            performRequest.setDryRun(Boolean.valueOf(this.dryRun));
            this.releaseManager.perform(performRequest);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    void setDeploymentRepository() {
    }

    void createGoals() {
        if (this.goals == null) {
            this.goals = "deploy";
            if (this.project.getDistributionManagement() != null && this.project.getDistributionManagement().getSite() != null) {
                this.goals = this.goals + " site-deploy";
            }
        }
    }
}

